package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.ExternalCustomerCallbackLogEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.dao.mapper.ExternalCusCallLogMapper;
import com.house365.ws.interfaces.server.IExternalCusCallLogInterface;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Administrator on 2020/7/1.
 */
@Service("externalCusCallLog")
public class ExternalCusCallLogImpl implements IExternalCusCallLogInterface {

    @Autowired
    private ExternalCusCallLogMapper cusCallLogMapper;

    @Override
    public void saveCallBackLog(ExternalCustomerCallbackLogEntity entity) {
        cusCallLogMapper.saveCallBackLog(entity);
    }

    @Override
    public List<ExternalCustomerCallbackLogEntity> queryByConditions(Map<String, Object> map) {
        List<ExternalCustomerCallbackLogEntity> list = cusCallLogMapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
