package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CustomerLogEntity;
import com.house365.ws.dao.mapper.CustomerLogMapper;
import com.house365.ws.interfaces.server.ICustomerLogInterface;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Administrator on 2019/8/19.
 */
@Service("customerLog")
public class CustomerLogImpl implements ICustomerLogInterface {

    @Autowired
    private CustomerLogMapper logMapper;

    @Override
    public List<CustomerLogEntity> queryByConditions(Map<String, Object> map) {
        List<CustomerLogEntity> list = logMapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }
}
