/**
 * Description: UserSourceStatistics数据访问接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-25 上午 09:36:01
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-25   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;

import com.house365.beans.entity.UserSourceStatisticsEntity;

import java.util.List;
import java.util.Map;

/**
 * UserSourceStatistics数据访问接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-25
 * @see
 * @since 1.0
 */
public interface IUserSourceStatisticsDao<T extends UserSourceStatisticsEntity> extends Dao<T> {
    List<Map> statisticCustomer(QueryParams<?> queryParams);

    int countStatisticCustomer(QueryParams<?> params);

    List<Map> statisticCustomerByWeek(QueryParams<T> queryParams);

    int countStatisticCustomerByWeek(QueryParams<?> params);

    List<Map> statisticCustomerByMonth(QueryParams<T> queryParams);

    int countStatisticCustomerByMonth(QueryParams<?> params);

    List<Map> statisticStatusSource(QueryParams para);

    int countStatusSource(QueryParams<?> params);

    List<Map> statisticStatusSourceByWeek(QueryParams<T> queryParams);

    int countStatusSourceByWeek(QueryParams<?> params);

    List<Map> statisticStatusSourceByMonth(QueryParams<T> queryParams);

    int countStatusSourceByMonth(QueryParams<?> params);

    List<Map> transCustomer(
        QueryParams<T> params
    );

    int countTransCustomer(QueryParams<?> params);

    List<Map> transCustomerByWeek(
        QueryParams<T> params
    );

    int countTransCustomerByWeek(QueryParams<?> params);

    List<Map> transCustomerByMonth(
        QueryParams<T> params
    );

    int countTransCustomerByMonth(QueryParams<?> params);

    void updateProjectName();

    void updateSourceName();

    void updateCityName();

    void deleteByDate(String startDateStr);
}
