/**
 * Description: 账户数据访问接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-14 下午 17:27:22
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.RequestLoginEntity;
import com.house365.beans.entity.UserEvaluateEntity;
import com.house365.beans.entity.VersionEntity;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.ManagerVO;
import com.house365.dao.system.interfaces.Dao;

import com.house365.beans.entity.UserEntity;

import java.util.List;
import java.util.Map;

/**
 * 账户数据访问接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public interface IUserDao<T extends UserEntity> extends Dao<T>{
    List<String> getMobilesByProject(Integer projectId);

    List<Integer> getUserIdOnPath(Integer parentId);

    List<String> getIdsByProject(Integer projectId);

    Map<String, Object> getSummary(String managerId);
    List<UserEntity> getUserByPorjectShort(Map<String, Object> queryMap);

    List queryShortNum4Crm();

    List<UserEvaluateEntity> queryEvaluateListById(UserEvaluateEntity uue);
    void reviewStatus(UserEvaluateEntity uue);
    void delEvaluationById(UserEvaluateEntity uue);
    void bindAccid(UserEntity userentity);
    List<VersionEntity> getAppVersionList(QueryParams<VersionEntity> queryParams);
    List<RequestLoginEntity> getAuthorizationList(QueryParams<RequestLoginEntity> queryParams);
    Integer countAuthorizationList(QueryParams<RequestLoginEntity> queryParams);

    List<UserEntity> getRemotePath(Integer resourceId);
    List<UserEntity> getCityName(String city);
    List<UserEntity> getUserEvaluation(String city);
    List<UserEntity> getByCity(String city);
    void saveUnbindLog(UserEntity entity);

    List<UserEntity> queryByName(Map<String,Object> map);

    /**
     * 统计下属个数
     *
     * @param userId
     * @return
     */
    Integer countSubordinate(Integer userId);
    List<UserEntity> getAccidByName(Map<String, Object> queryMap);
}
