/**
 * Description: 驻场日报数据访问接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-07-17 上午 10:14:22
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.LocalReportEntity;
import com.house365.beans.po.ReportDailyPo;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.LocalReportFormVo;
import com.house365.dao.system.interfaces.Dao;

import java.util.List;
import java.util.Map;

/**
 * 驻场日报数据访问接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public interface ILocalReportDao<T extends LocalReportEntity> extends Dao<T>{

    List<LocalReportFormVo> queryFormVORecord(String city, String reportDate, Integer projectId);

    List<LocalReportFormVo> queryFormVO(String city);

    void cleanDayReportByProject(String projectId, String date);

    List<LocalReportFormVo> statistic(QueryParams<?> queryParams);

    int countStatistic(QueryParams<?> params);

    List<ReportDailyPo> getDailies(Map<String, Object> param);
}
