package com.house365.ws.dao.impl;

import com.house365.beans.entity.VersionEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IVersionDao;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("versionDao")
public class VersionDaoImpl extends DefaultDaoImpl<VersionEntity> implements IVersionDao<VersionEntity> {

    @Override
    public List<VersionEntity> getLastVersion(VersionEntity ve) {
        return getReadTemplate().queryForList(getStatement(), ve);
    }

    @Override
    public void deleteVersionById(Integer id) {
        getReadTemplate().delete(getStatement(), id);
    }

    @Override
    public List<VersionEntity> getAppVersionList(QueryParams<VersionEntity> queryParams) {

        return getReadTemplate().queryForList(getStatement(), queryParams);
    }

}
