/**
 * Description: UserSourceStatistics数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-25 上午 09:36:01
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-25   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.UserSourceStatisticsEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IUserSourceStatisticsDao;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * UserSourceStatistics数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-25
 * @see
 * @since 1.0
 */
@Repository("userSourceStatisticsDao")
public class UserSourceStatisticsDaoImpl extends DefaultDaoImpl<UserSourceStatisticsEntity> implements IUserSourceStatisticsDao<UserSourceStatisticsEntity> {

    @Override
    public List<Map> statisticCustomer(QueryParams<?> params) {

        if (params != null && params.getPaging() != null) {
            int records = countStatisticCustomer(params);
            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
            if (records == 0) {
                return new ArrayList(0);
            }
            params.getPaging().setRecords(records);
        }

        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public int countStatisticCustomer(QueryParams<?> params) {
        if (params == null) {
            return (Integer) this.getReadTemplate().queryForObject(getStatement());
        }
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
    }

    @Override
    public List<Map> statisticCustomerByWeek(
        QueryParams<UserSourceStatisticsEntity> params
    ) {

        if (params != null && params.getPaging() != null) {
            int records = countStatisticCustomerByWeek(params);
            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
            if (records == 0) {
                return new ArrayList(0);
            }
            params.getPaging().setRecords(records);
        }

        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public int countStatisticCustomerByWeek(QueryParams<?> params) {
        if (params == null) {
            return (Integer) this.getReadTemplate().queryForObject(getStatement());
        }
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
    }

    @Override
    public List<Map> statisticCustomerByMonth(
        QueryParams<UserSourceStatisticsEntity> params
    ) {

        if (params != null && params.getPaging() != null) {
            int records = countStatisticCustomerByMonth(params);
            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
            if (records == 0) {
                return new ArrayList(0);
            }
            params.getPaging().setRecords(records);
        }

        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public int countStatisticCustomerByMonth(QueryParams<?> params) {
        if (params == null) {
            return (Integer) this.getReadTemplate().queryForObject(getStatement());
        }
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
    }


    @Override
    public List<Map> statisticStatusSource(QueryParams params) {
        if (params != null && params.getPaging() != null) {
            int records = countStatusSource(params);
            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
            if (records == 0) {
                return new ArrayList(0);
            }
            params.getPaging().setRecords(records);
        }

        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public int countStatusSource(QueryParams<?> params) {
        if (params == null) {
            return (Integer) this.getReadTemplate().queryForObject(getStatement());
        }
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
    }

    @Override
    public List<Map> statisticStatusSourceByWeek(
        QueryParams<UserSourceStatisticsEntity> params
    ) {
        if (params != null && params.getPaging() != null) {
            int records = countStatusSourceByWeek(params);
            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
            if (records == 0) {
                return new ArrayList(0);
            }
            params.getPaging().setRecords(records);
        }

        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public int countStatusSourceByWeek(QueryParams<?> params) {
        if (params == null) {
            return (Integer) this.getReadTemplate().queryForObject(getStatement());
        }
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
    }

    @Override
    public List<Map> statisticStatusSourceByMonth(
        QueryParams<UserSourceStatisticsEntity> params
    ) {
        if (params != null && params.getPaging() != null) {
            int records = countStatusSourceByMonth(params);
            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
            if (records == 0) {
                return new ArrayList(0);
            }
            params.getPaging().setRecords(records);
        }

        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public int countStatusSourceByMonth(QueryParams<?> params) {
        if (params == null) {
            return (Integer) this.getReadTemplate().queryForObject(getStatement());
        }
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
    }


    @Override
    public List<Map> transCustomer(
        QueryParams<UserSourceStatisticsEntity> params
    ) {
        if (params != null && params.getPaging() != null) {
            int records = countTransCustomer(params);
            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
            if (records == 0) {
                return new ArrayList(0);
            }
            params.getPaging().setRecords(records);
        }

        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public int countTransCustomer(QueryParams<?> params) {
        if (params == null) {
            return (Integer) this.getReadTemplate().queryForObject(getStatement());
        }
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
    }

    @Override
    public List<Map> transCustomerByWeek(
        QueryParams<UserSourceStatisticsEntity> params
    ) {
        if (params != null && params.getPaging() != null) {
            int records = countTransCustomerByWeek(params);
            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
            if (records == 0) {
                return new ArrayList(0);
            }
            params.getPaging().setRecords(records);
        }

        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public int countTransCustomerByWeek(QueryParams<?> params) {
        if (params == null) {
            return (Integer) this.getReadTemplate().queryForObject(getStatement());
        }
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
    }

    @Override
    public List<Map> transCustomerByMonth(
        QueryParams<UserSourceStatisticsEntity> params
    ) {
        if (params != null && params.getPaging() != null) {
            int records = countTransCustomerByMonth(params);
            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
            if (records == 0) {
                return new ArrayList(0);
            }
            params.getPaging().setRecords(records);
        }

        return this.getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public int countTransCustomerByMonth(QueryParams<?> params) {
        if (params == null) {
            return (Integer) this.getReadTemplate().queryForObject(getStatement());
        }
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
    }

    @Override
    public void updateProjectName() {
        this.getReadTemplate().update(getStatement());
    }

    @Override
    public void updateSourceName() {
        this.getReadTemplate().update(getStatement());
    }

    @Override
    public void updateCityName() {
        this.getReadTemplate().update(getStatement());
    }

    @Override
    public void deleteByDate(String startDateStr) {
        this.getReadTemplate().delete(getStatement(), startDateStr);
    }


}
