/**
 * Description: 客户信息数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:13
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.CrmVisitAndSignCustomer;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.ICustomerDao;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 客户信息数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
@Repository("customerDao")
public class CustomerDaoImpl extends DefaultDaoImpl<CustomerEntity> implements ICustomerDao<CustomerEntity> {

    @Override
    public void updateManager(Integer managerId, String managerName) {
        Map<String, Object> para = new HashMap<>();
        para.put("managerId", managerId);
        para.put("managerName", managerName);
        getWriteTemplate().update(this.getStatement(), para);
    }

    @Override
    public Map<String, Object> getSummary(String managerId) {
        return (Map<String, Object>) getObject(getStatement(), managerId);
    }

    @Override
    public Map<String, Object> getNewSummary(Map<String, String> summaryParams) {
        return (Map<String, Object>) getObject(getStatement(), summaryParams);
    }

    @Override
    public Map<String, Object> getSummarySimple(String managerId) {
        return (Map<String, Object>) getObject(getStatement(), managerId);
    }

    @Override
    public Map<String, Object> getSummaryForCRM(String phone) {
        return (Map<String, Object>) getObject(getStatement(), phone);
    }

    @Override
    public Map<String, Object> getSummary7ForCRM(String phone) {
        return (Map<String, Object>) getObject(getStatement(), phone);
    }

    @Override
    public Map<String, Object> getSeaSummary(String managerId) {
        return (Map<String, Object>) getObject(getStatement(), managerId);
    }

    @Override
    public Map<String, Object> getSeaSummary2(String managerId) {
        return (Map<String, Object>) getObject(getStatement(), managerId);
    }

    @Override
    public void delDynamic(Integer dynamicId) {
        getReadTemplate().update(getStatement(), dynamicId);
    }

    @Override
    public Map<String, Object> getSeaSummary3(String managerId) {
        return (Map<String, Object>) getObject(getStatement(), managerId);
    }

    @Override
    public Map<String, Object> getWechatMyCucstomerSummary(String managerId) {
        return (Map<String, Object>) getObject(getStatement(), managerId);
    }

    @Override
    public List<Map<String, Object>> getWechatMyCucstomerUserView(String managerId, String pageNo, String pageSize) {
        Integer page = (Integer.parseInt(pageNo) - 1) < 0 ? 0 : (Integer.parseInt(pageNo) - 1);
        Integer pn = page * Integer.parseInt(pageSize);

        Map<String, Object> parameter = new HashedMap();
        parameter.put("managerId", managerId);
        parameter.put("startRecord", pn);
        parameter.put("pageSize", Integer.parseInt(pageSize));

        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    @Override
    public List<Map<String, Object>> statisticByUser(Map<String, String> parameter) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    @Override
    public List<Map<String, Object>> statisticByStatus(Map<String, String> parameter) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    @Override
    public List<Map<String, Object>> statisticByDept(Map<String, String> parameter) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    @Override
    public List<Map<String, Object>> statisticByProject(Map<String, String> parameter) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    @Override
    public List<Map<String, Object>> statisticNoRecordByUser(Map<String, String> parameter) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    @Override
    public List<Map<String, Object>> statisticNoRecordByDept(Map<String, String> parameter) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    @Override
    public List<Map<String, Object>> statisticNoRecordByStatus(Map<String, String> parameter) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    @Override
    public void updateName(String oldName, String name) {
        Map<String, Object> para = new HashMap();
        para.put("id", oldName);
        para.put("name", name);
        this.update(getStatement(), para);
    }


    @Override
    public List<Map<String, Object>> getNewCustomerIds(String managerId) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), managerId);
    }

    @Override
    public List<Map<String, Object>> getTodayUpdateIds(String managerId) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), managerId);
    }

    @Override
    public List<Map<String, Object>> getNocallSevenDayIds(String managerId) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), managerId);
    }

    @Override
    public List<Map<String, Object>> getNocallThreeDayIds(String managerId) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), managerId);
    }

    @Override
    public List<Map<String, Object>> getNoStatusUpdateIds(String managerId) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), managerId);
    }

    @Override
    public List<Map<String, Object>> getNoVisitIdsByDays(Map<String, Object> parameter) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    @Override
    public List<Map<String, Object>> getNoPledgedIdsByDays(Map<String, Object> parameter) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    //今日新增客户
    @Override
    public List<Integer> getNewAddCustomerIds(String managerId) {
        return (List<Integer>) getReadTemplate().queryForList(getStatement(), managerId);
    }

    //3天内回访的客户
    @Override
    public List<Integer> getCallInThreeDayIds(String managerId) {
        return (List<Integer>) getReadTemplate().queryForList(getStatement(), managerId);
    }

    //星标客户
    @Override
    public List<Integer> getStarCustomerIds(String managerId) {
        return (List<Integer>) getReadTemplate().queryForList(getStatement(), managerId);
    }

    //7日新增客户
    @Override
    public List<Integer> getSevenDayNewCustomerIds(String managerId) {
        return (List<Integer>) getReadTemplate().queryForList(getStatement(), managerId);
    }

    //客户最后回访记录
    @Override
    public List<Map<String, Object>> getLastestCallback(String customerIds) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), customerIds);
    }

    @Override
    public List<CustomerEntity> getCustomerManagementList(QueryParams<CustomerEntity> queryParams) {
        return (List<CustomerEntity>) this.queryByQueryParams(getStatement(), queryParams);
    }

    @Override
    public List<CustomerEntity> getPlatformCustomerList(QueryParams<CustomerEntity> queryParams) {
        return (List<CustomerEntity>) this.queryByQueryParams(getStatement(), queryParams);
    }

    @Override
    public List<CustomerEntity> getCustomerManagementList4Label(QueryParams<CustomerEntity> queryParams) {
//        queryParams.getSearchParams().put("EQ_userId", userId);
//        queryParams.getSearchParams().put("EQ_labelId", labelId);
        return (List<CustomerEntity>) this.queryByQueryParams(getStatement(), queryParams);
    }

    @Override
    public List<CustomerEntity> getCustomerListFromOld(QueryParams<CustomerEntity> queryParams) {
        return (List<CustomerEntity>) this.queryByQueryParams(getStatement(), queryParams);
    }

    @Override
    public List<CustomerEntity> getTotalCallOptimizeList(QueryParams<CustomerEntity> queryParams) {
        return (List<CustomerEntity>) this.queryByQueryParams(getStatement(), queryParams);
    }

    @Override
    public List<CustomerEntity> getWechatCustomers(QueryParams<CustomerEntity> queryParams) {
        return (List<CustomerEntity>) this.queryByQueryParams(getStatement(), queryParams);
    }

    @Override
    public void removeFromOcean() {
        getWriteTemplate().delete(getStatement());
    }

    @Override
    public Integer getTotalCall(QueryParams<CustomerEntity> queryParams) {
        return (Integer) getWriteTemplate().queryForObject(getStatement(), queryParams);
    }

    @Override
    public Integer getTotalCallOptimize(QueryParams<CustomerEntity> queryParams) {
        return (Integer) getWriteTemplate().queryForObject(getStatement(), queryParams);
    }

    @Override
    public Integer getTotalAbandon(QueryParams<CustomerEntity> queryParams) {
        return (Integer) getWriteTemplate().queryForObject(getStatement(), queryParams);
    }

    @Override
    public List<Map<String, Object>> getNoCallByHours(Map<String, Object> parameter) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), parameter);
    }

    @Override
    public List<Map<String, Object>> getMarketInfo(QueryParams<CustomerEntity> queryParams) {
        return (List<Map<String, Object>>) getReadTemplate().queryForList(getStatement(), queryParams);
    }

    @Override
    public List<CrmVisitAndSignCustomer> crmVisitAndSignCustomer(Map<String, Object> queryParams) {
        return (List<CrmVisitAndSignCustomer>) getReadTemplate().queryForList(getStatement(), queryParams);
    }

    @Override
    public void updateOldCustomers(CustomerEntity customer) {
        getReadTemplate().update(getStatement(), customer);
    }

}
