/**
 * Description: UserStarWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-05-15 下午 17:04:55
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-05-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.UserStarListRequest;
import com.house365.ws.beans.request.UserStarRequest;
import com.house365.ws.beans.response.UserStarListResponse;
import com.house365.ws.beans.response.UserStarResponse;


/**
 * UserStarWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-05-15
 * @see
 * @since 1.0
 */
public interface IUserStar extends IService{

    /**
     * UserStar列表查询
     * 
     * @param request
     *            UserStar列表查询请求
     * @return UserStar列表查询响应
     */
    UserStarListResponse getUserStarList(
        UserStarListRequest request
    );

    /**
     * 保存UserStar
     * 
     * @param request
     *            UserStar请求
     * @return 保存UserStar响应
     */
    UserStarResponse addUserStar(UserStarRequest request);

    /**
     * 删除UserStar通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除UserStar响应
     */
    UserStarResponse deleteUserStarById(Integer id);

    /**
     * 修改UserStar
     * 
     * @param request
     *            修改UserStar请求
     * @return 修改UserStar响应
     */
    UserStarResponse updateUserStar(
        UserStarRequest request
    );

    /**
     * 通过ID获取UserStar
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取UserStar响应
     */
    UserStarResponse getUserStarById(Integer id);
}
