/**
 * Description: 角色权限关联WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-14 下午 17:27:23
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.UserRoleListRequest;
import com.house365.ws.beans.request.UserRoleRequest;
import com.house365.ws.beans.response.UserRoleListResponse;
import com.house365.ws.beans.response.UserRoleResponse;


/**
 * 角色权限关联WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public interface IUserRole extends IService{

    /**
     * 角色权限关联列表查询
     * 
     * @param request
     *            角色权限关联列表查询请求
     * @return 角色权限关联列表查询响应
     */
    UserRoleListResponse getUserRoleList(
            UserRoleListRequest request);

    /**
     * 保存角色权限关联
     * 
     * @param request
     *            角色权限关联请求
     * @return 保存角色权限关联响应
     */
    UserRoleResponse addUserRole(UserRoleRequest request);

    /**
     * 删除角色权限关联通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除角色权限关联响应
     */
    UserRoleResponse deleteUserRoleById(Integer id);

    /**
     * 修改角色权限关联
     * 
     * @param request
     *            修改角色权限关联请求
     * @return 修改角色权限关联响应
     */
    UserRoleResponse updateUserRole(
            UserRoleRequest request);

    /**
     * 通过ID获取角色权限关联
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取角色权限关联响应
     */
    UserRoleResponse getUserRoleById(Integer id);
}
