/**
 * Description: 直销人员楼盘推荐WS接口
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-22 下午 13:57:27
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-22   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.UserProjectRecommendEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.UserProjectRecommendListRequest;
import com.house365.ws.beans.request.UserProjectRecommendRequest;
import com.house365.ws.beans.response.UserProjectRecommendListResponse;
import com.house365.ws.beans.response.UserProjectRecommendResponse;
import com.house365.ws.beans.util.HResult;


/**
 * 直销人员楼盘推荐WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-22
 * @see
 * @since 1.0
 */
public interface IUserProjectRecommend extends IService {

    /**
     * 直销人员楼盘推荐列表查询
     *
     * @param request
     *            直销人员楼盘推荐列表查询请求
     * @return 直销人员楼盘推荐列表查询响应
     */
    UserProjectRecommendListResponse getUserProjectRecommendList(
            UserProjectRecommendListRequest request);

    /**
     * 保存直销人员楼盘推荐
     *
     * @param request
     *            直销人员楼盘推荐请求
     * @return 保存直销人员楼盘推荐响应
     */
    UserProjectRecommendResponse addUserProjectRecommend(UserProjectRecommendRequest request);

    HResult save(UserProjectRecommendEntity entity);

    /**
     * 删除直销人员楼盘推荐通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除直销人员楼盘推荐响应
     */
    UserProjectRecommendResponse deleteUserProjectRecommendById(Integer id);

    /**
     * 修改直销人员楼盘推荐
     *
     * @param request
     *            修改直销人员楼盘推荐请求
     * @return 修改直销人员楼盘推荐响应
     */
    UserProjectRecommendResponse updateUserProjectRecommend(
            UserProjectRecommendRequest request);

    /**
     * 通过ID获取直销人员楼盘推荐
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取直销人员楼盘推荐响应
     */
    UserProjectRecommendResponse getUserProjectRecommendById(Integer id);
}
