/**
 * Description: 抢客规则WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-11-28 下午 13:41:47
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-11-28   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.RushCustomerRuleListRequest;
import com.house365.ws.beans.request.RushCustomerRuleRequest;
import com.house365.ws.beans.response.RushCustomerRuleListResponse;
import com.house365.ws.beans.response.RushCustomerRuleResponse;


/**
 * 抢客规则WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-11-28
 * @see
 * @since 1.0
 */
public interface IRushCustomerRule extends IService {

    /**
     * 抢客规则列表查询
     *
     * @param request 抢客规则列表查询请求
     * @return 抢客规则列表查询响应
     */
    RushCustomerRuleListResponse getRushCustomerRuleList(
            RushCustomerRuleListRequest request);

    /**
     * 保存抢客规则
     *
     * @param request 抢客规则请求
     * @return 保存抢客规则响应
     */
    RushCustomerRuleResponse addRushCustomerRule(RushCustomerRuleRequest request);

    /**
     * 删除抢客规则通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除抢客规则响应
     */
    RushCustomerRuleResponse deleteRushCustomerRuleById(Integer id);

    /**
     * 修改抢客规则
     *
     * @param request 修改抢客规则请求
     * @return 修改抢客规则响应
     */
    RushCustomerRuleResponse updateRushCustomerRule(
            RushCustomerRuleRequest request);

    /**
     * 通过ID获取抢客规则
     *
     * @param id 唯一标识
     * @return 通过ID获取抢客规则响应
     */
    RushCustomerRuleResponse getRushCustomerRuleById(Integer id);

    void changeRuleStatus(Integer ruleId, Integer status, Integer userId, String userName);
}
