/**
 * Description: HouseInfoWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-12-18 下午 15:44:53
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.HouseInfoListRequest;
import com.house365.ws.beans.request.HouseInfoRequest;
import com.house365.ws.beans.response.HouseInfoListResponse;
import com.house365.ws.beans.response.HouseInfoResponse;


/**
 * HouseInfoWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-18
 * @see
 * @since 1.0
 */
public interface IHouseInfo extends IService{

    /**
     * HouseInfo列表查询
     * 
     * @param request
     *            HouseInfo列表查询请求
     * @return HouseInfo列表查询响应
     */
    HouseInfoListResponse getHouseInfoList(
        HouseInfoListRequest request
    );

    /**
     * 保存HouseInfo
     * 
     * @param request
     *            HouseInfo请求
     * @return 保存HouseInfo响应
     */
    HouseInfoResponse addHouseInfo(HouseInfoRequest request);

    /**
     * 删除HouseInfo通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除HouseInfo响应
     */
    HouseInfoResponse deleteHouseInfoById(Integer id);

    /**
     * 修改HouseInfo
     * 
     * @param request
     *            修改HouseInfo请求
     * @return 修改HouseInfo响应
     */
    HouseInfoResponse updateHouseInfo(
        HouseInfoRequest request
    );

    /**
     * 通过ID获取HouseInfo
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取HouseInfo响应
     */
    HouseInfoResponse getHouseInfoById(Integer id);

    HouseInfoListResponse getHouseInfoListByActiveId(Integer activeId);

    void updateHouseNameByActiveId(Integer id, String city);

}
