<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>直销报表</title>
</head>
<body>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" name="filterForm" class="form-inline filterForm"
                  action="${ctx}/statistic/reportMarketingStatistic" method="get">
                <div style="margin-top:10px;">
                    <c:if test="${not empty departmentList}">
                        &nbsp;&nbsp;部门：&nbsp;&nbsp;
                        <select name="department" id="department" class="span10 nochosen  multiselect"
                                multiple="multiple"
                                data-placeholder="部门">
                            <option value='all'
                                    <c:if test="${param['department'] eq 'all' or param['department'] eq null}">selected="selected"</c:if>>
                                全部
                            </option>
                            <c:forEach items="${departmentList}" var="d">
                                <option value="${d.id}"
                                        <c:if test="${'1' eq d.type}">selected="selected"</c:if>>${d.name}</option>
                            </c:forEach>
                        </select>

                        &nbsp;&nbsp;
                        &nbsp;&nbsp;&nbsp;&nbsp;职员：&nbsp;&nbsp;
                        <span id="userDiv">
                            <select name="user" id="user" class="span10 nochosen  multiselect" multiple="multiple"
                                    data-placeholder="职员">
                                <option value='all'
                                        <c:if test="${param['user'] eq 'all'}">selected="selected"</c:if>>全部</option>
                                <%--<c:forEach items="${userList}" var="u">--%>
                                    <%--<option value="${u.id}"--%>
                                            <%--<c:if test="${'1' eq u.weiXinId}">selected="selected"</c:if>>${u.realName}</option>--%>
                                <%--</c:forEach>--%>

                            </select>
                        </span>
                    </c:if>
                </div>
                <div style="margin-top:10px;">&nbsp;&nbsp;日期类型：&nbsp;&nbsp;
                    <select name="dateViewType" id="dateViewType" class="form-inline chosen">
                        <option value="1" <c:if test="${param['dateViewType']==1}">selected="selected"</c:if>>日视图
                        </option>
                        <option value="2" <c:if test="${param['dateViewType']==2}">selected="selected"</c:if>>周视图
                        </option>
                        <option value="3" <c:if test="${param['dateViewType']==3}">selected="selected"</c:if>>月视图
                        </option>
                    </select>
                    &nbsp;&nbsp;
                </div>

                <div style="margin-top:10px;">&nbsp;&nbsp;数据日期：&nbsp;&nbsp;
                    <input type="text" name="startTime" id="startTime"
                           value="${startDate}"
                           class="m-wrap small mydate span2 " placeholder="起始时间">到
                    <input type="text" name="endTime" id="endTime"
                           value="${endDate}"
                           class="m-wrap small mydate span2 " placeholder="截止时间">

                    &nbsp;&nbsp;<a class="btn " onclick="btnSubmit();">提交</a>
                    &nbsp;&nbsp;<a class="btn "
                                   onclick="$('#filterForm').attr('action','${ctx}/statistic/reportMarketingStatisticExcel');$('#filterForm').submit();$('#filterForm').attr('action','${ctx}/statistic/reportMarketingStatistic');">Excel下载</a>
                </div>
                <input type="hidden" id="departmentIds" name="departmentIds" value="${departmentIds}"/>
                <input type="hidden" id="departmentNames" name="departmentNames" value="${departmentNames}"/>
                <input type="hidden" id="userIds" name="userIds" value="${userIds}"/>
                <input type="hidden" id="userNames" name="userNames" value="${userNames}"/>
                <input type="hidden" id="displayTab" name="displayTab" value="${displayTab}"/>

            </form>
        </div>

        <ul class="nav nav-tabs" role="tablist" style="background-color: #fff;">
            <%--<li id="reportLi" role="presentation" class="active"><a href="#" onclick="dispayFun(1)">条形图展示</a></li>--%>
            <li id="tableLi" role="presentation" class="active"><a href="#" onclick="dispayFun(2)">表格详情</a></li>
        </ul>

        <div class="span12" id="report" style="height:650px;">
            <!-- <div hidden="hidden" id="emptyMsg">
                 <span>请选择查询条件</span>
             </div> -->
            <!--  <div id="emptyMsg" class="alert alert-success span2" role="alert">请选择查询条件</div> -->
        </div>
        <div class="span11" id="table" style="display:none;">
            <table class="table table-bordered table-advance table-hover">
                <tr class="info">
                    <td width="100" style="text-align:center">日期</td>
                    <td width="100" style="text-align:center">部门</td>
                    <td width="100" style="text-align:center">姓名</td>
                    <td width="100" style="text-align:center">电话接触量</td>
                    <td width="100" style="text-align:center">电话接通量</td>
                    <td width="100" style="text-align:center">意向沉淀量</td>
                    <td width="100" style="text-align:center">到访量</td>
                    <td width="100" style="text-align:center">认筹量</td>
                    <td width="100" style="text-align:center">认购量</td>
                    <td width="100" style="text-align:center">业绩</td>
                </tr>
                <c:forEach items="${tableData}" var="item">
                    <tr>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.reportTime}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.departmentName}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.userName}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.callCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.connectCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.intentBuyCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.visitedCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.identificationChipsCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.subscriptionCount}
                        </td>
                        <td nowrap="nowrap" style="text-align:center;">
                                ${item.source}
                        </td>
                    </tr>
                </c:forEach>
            </table>
        </div>
    </div>
</div>

<input type="hidden" value="${queryUser}" name="queryUser" id="queryUser">

<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script src="${ctx}/resources/script/echarts/echarts.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>

<script type="text/javascript">
    $(document).ready(function () {
        if ($('#department')) {
            $('#department').multiselect({
                includeSelectAllOption: true,
                enableFiltering: true,
                maxHeight: 500,
                buttonWidth: 320,
                numberDisplayed: 2,
                filterPlaceholder: '请输入部门名',
                includeSelectAllOption: false,
                templates: {
                    filterClearBtn: '<span></span>',
                },
                buttonText: function (options) {
                    if (options.length == 0) {
                        return '未选择部门 ';
                    } else if (options.length > 5) {
                        return '已选' + options.length + '个 ';
                    } else {
                        var selected = '';
                        options.each(function () {
                            selected += $(this).text() + ', ';
                        });
                        return selected.substr(0, selected.length - 2);
                    }

                },
                optionLabel: function (element) {
                    return $(element).html();
                },
                onInitialized: function (select, container) {
                    var selectedOptions = $('#department option:selected');
                    var userSelectedOptions = $('#user option:selected').val();
                    var contain = $('#userDiv');
                    contain.empty();
                    if (userSelectedOptions == 'all') {
                        contain.append("<select name=\"user\" id=\"user\" class=\"span10 nochosen  multiselect\" multiple=\"multiple\" data-placeholder=\"职员\"><option value='all' selected>全部</option></select>");
                    } else {
                        contain.append("<select name=\"user\" id=\"user\" class=\"span10 nochosen  multiselect\" multiple=\"multiple\" data-placeholder=\"职员\"><option value='all'>全部</option></select>");
                    }

                    var deptId = "";
                    if (selectedOptions.val() == 'all') {
                        var nonSelectedOptions = $('#department option').filter(function () {
                            return !$(this).is(':selected');
                        });

                        var dropdown = $('#department').siblings('.open');
                        nonSelectedOptions.each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', true);
                            input.parent('li').addClass('disabled');
                        });

                        $('#department option').each(function () {
                            if ('all' != $(this).val()) {
                                deptId += $(this).val() + ",";
                            }
                        });
                    } else {
                        var dropdown = $('#department').siblings('.open');
                        $('#department option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                        selectedOptions.each(function () {
                            deptId += $(this).val() + ",";
                        });
                    }

                    if (selectedOptions.val()) {
                        $.ajax({
                            url: "${ctx}/user/getUserAjax",
                            type: "GET",
                            data: {dept: deptId, queryUser: $("#queryUser").val()},
                            dataType: "json",
                            success: function (data) {
                                var user = $('#user');
                                $(data).each(function () {
                                    if ('1' == this.weiXinId) {
                                        user.append("<option selected value='" + this.id + "'>" + this.realName + "</option>");
                                    } else {
                                        user.append("<option value='" + this.id + "'>" + this.realName + "</option>");
                                    }
                                });
                            },
                            complete: function () {
                                initUser();
                            }
                        });
                    } else {
                        initUser();
                    }

                },
                onChange: function (option, checked) {
                    var selectedOptions = $('#department option:selected');
                    var contain = $('#userDiv');
                    contain.empty();
                    contain.append("<select name=\"user\" id=\"user\" class=\"span10 nochosen  multiselect\" multiple=\"multiple\" data-placeholder=\"职员\">\n" +
                        "<option value='all'>全部</option></select>");

                    var deptId = "";
                    if (selectedOptions.val() == 'all') {
                        var nonSelectedOptions = $('#department option').filter(function () {
                            return !$(this).is(':selected');
                        });
                        var dropdown = $('#department').siblings('.open');
                        nonSelectedOptions.each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', true);
                            input.parent('li').addClass('disabled');
                        });

                        $('#department option').each(function () {
                            if ('all' != $(this).val()) {
                                deptId += $(this).val() + ",";
                                $(this).removeAttr("selected");
                                $('#department').multiselect('refresh');
                            }
                        });
                    } else {
                        var dropdown = $('#department').siblings('.open');
                        $('#department option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                        selectedOptions.each(function () {
                            deptId += $(this).val() + ",";
                        });
                    }

                    if (selectedOptions.val()) {
                        $.ajax({
                            url: "${ctx}/user/getUserAjax",
                            type: "GET",
                            data: {dept: deptId},
                            dataType: "json",
                            success: function (data) {
                                var user = $('#user');
                                $(data).each(function () {
                                    user.append("<option value='" + this.id + "'>" + this.realName + "</option>");
                                });
                            },
                            complete: function () {
                                initUser();
                            }
                        });
                    } else {
                        initUser();
                    }

                }
            });
        }

        var startTime = $("#startTime");
        var endTime = $("#endTime");
        endTime.bind("focus", function () {
            WdatePicker({startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-%d'});
        });
        startTime.bind("focus", function () {
            WdatePicker({
                startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-%d',
                onpicked: function () {
                    WdatePicker({
                        /* doubleCalendar: true, */
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        maxDate: '%y-%M-%d',
                        el: 'endTime'
                    })
                }
            });
        });

        <c:if test="${'1' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-%d'});
        });
        </c:if>
        <c:if test="${'2' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({isShowWeek: true, maxDate: '%y-%M-%d'});
        });
        </c:if>
        <c:if test="${'3' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-%d'});
        });
        </c:if>

        $("#dateViewType").change(function () {
            var val = $(this).val();
            $(".mydate").val("");
            if (val == 1) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-%d'});
                });
            } else if (val == 2) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({isShowWeek: true, maxDate: '%y-%M-%d'});
                });
            } else {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-%d'});
                });
            }
            setTime();
        });

//        drawReport();

        dispayFun("${displayTab}");
        setTime();
    });

    function setTime() {
        var val = $("#dateViewType").val();
        var startTime = $("#startTime");
        var endTime = $("#endTime");

        if ($("#dateViewType").val() != '') {
            if (val == 1) {
                if (startTime.val() == '') {
                    startTime.val(getToday());
                }
                if (endTime.val() == '') {
                    endTime.val(getToday());
                }
            } else if (val == 2) {
                if (startTime.val() == '') {
                    startTime.val(getCurrentWeekStartDate());
                }
                if (endTime.val() == '') {
                    endTime.val(getCurrentWeekEndDate());
                }
            } else {
                if (startTime.val() == '') {
                    startTime.val(getCurrentMonthStartDate());
                }
                if (endTime.val() == '') {
                    endTime.val(getCurrentMonthEndDate());
                }
            }
        }

    }

    function initUser() {
        if ($('#user')) {
            $('#user').multiselect({
                includeSelectAllOption: true,
                enableFiltering: true,
                maxHeight: 500,
                buttonWidth: 320,
                numberDisplayed: 2,
                filterPlaceholder: '请输入职员名',
                includeSelectAllOption: false,
                templates: {
                    filterClearBtn: '<span></span>',
                },
                buttonText: function (options) {
                    if (options.length == 0) {
                        return '未选择职员 ';
                    } else if (options.length > 5) {
                        return '已选' + options.length + '个 ';
                    } else {
                        var selected = '';
                        options.each(function () {
                            selected += $(this).text() + ', ';
                        });
                        return selected.substr(0, selected.length - 2);
                    }
                },
                optionLabel: function (element) {
                    return $(element).html();
                },
                onInitialized: function (select, container) {
                    var selectedOptions = $('#user option:selected');

                    if (selectedOptions.val() == 'all') {
                        var nonSelectedOptions = $('#user option').filter(function () {
                            return !$(this).is(':selected');
                        });

                        var dropdown = $('#user').siblings('.open');
                        nonSelectedOptions.each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', true);
                            input.parent('li').addClass('disabled');
                        });
                    }
                    else {
                        var dropdown = $('#user').siblings('.open');
                        $('#user option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                    }
                },
                onChange: function (option, checked) {
                    var selectedOptions = $('#user option:selected');

                    if (selectedOptions.val() == 'all') {
                        var nonSelectedOptions = $('#user option').filter(function () {
                            return !$(this).is(':selected');
                        });

                        var dropdown = $('#user').siblings('.open');
                        nonSelectedOptions.each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', true);
                            input.parent('li').addClass('disabled');
                        });

                        $('#user option').each(function () {
                            if ('all' != $(this).val()) {
                                $(this).removeAttr("selected");
                                $('#user').multiselect('refresh');
                            }
                        });
                    } else {
                        var dropdown = $('#user').siblings('.open');
                        $('#user option').each(function () {
                            var input = dropdown.find('input[value="' + $(this).val() + '"]').first();
                            input.prop('disabled', false);
                            input.parent('li').addClass('disabled');
                        });
                    }
                }
            });

        }

    }


    function exportExcel() {
        document.filterForm.action = "${ctx}/statistic/projectSourceExcel";
        $('#filterForm').submit();
        document.filterForm.action = "${ctx}/statistic/projectSource";
    }

    function btnSubmit() {
        $('#filterForm').submit();
    }

    function dispayFun(obj) {
        if (obj == 1) {
            $("#report").show();
            $("#table").hide();
            $("#reportLi").addClass("active");
            $("#tableLi").removeClass("active");
            $("#displayTab").val("1");
        } else {
            $("#table").show();
            $("#report").hide();
            $("#tableLi").addClass("active");
            $("#reportLi").removeClass("active");
            $("#displayTab").val("2");
        }
    }
</script>
</body>
</html>
