<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>项目转化分析</title>
</head>
<body>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" name="filterForm" class="form-inline filterForm"
                  action="${ctx}/statistic/projectTransform" method="get">

                <select name="dateViewType" id="dateViewType" class="form-inline chosen">
                    <option value="1" <c:if test="${param['dateViewType']==1}">selected="selected"</c:if>>日视图</option>
                    <option value="2" <c:if test="${param['dateViewType']==2}">selected="selected"</c:if>>周视图</option>
                    <option value="3" <c:if test="${param['dateViewType']==3}">selected="selected"</c:if>>月视图</option>
                </select>
                <input type="text" name="startTime" id="startTime"
                       value="${startDate}"
                       class="m-wrap small mydate span2 " placeholder="添加时间">到
                <input type="text" name="endTime" id="endTime"
                       value="${endDate}"
                       class="m-wrap small mydate span2 " placeholder="添加时间">

                <%--<input type='hidden' id="information" name="information"--%>
                       <%--class="form-inline  chosen" style="width:15%;">--%>
                <%--<input type="text"--%>
                       <%--id="temp_information" name="temp_information"--%>
                       <%--class="form-inline chosen span3 " placeholder="请输入项目名" style="width:15%;"/>--%>

                <select name="project" id="project" class="span10 nochosen  multiselect" multiple="multiple"
                        data-placeholder="请输入项目名">
                    <c:forEach items="${projects}" var="p">
                        <option value="${p.id}"
                                <c:if test="${p.flag}">selected="selected"</c:if> >${p.projectName}</option>
                    </c:forEach>
                </select>
                <input type="hidden" id="projectIds" name="projectIds" value="${projectIds}"/>
                <input type="hidden" id="projectNames" name="projectNames" value="${projectNames}"/>

                <%--<input type='hidden' id="projectId" name="projectId"--%>
                       <%--class="form-inline" value="${param['projectId']}">--%>
                <%--<input type='hidden' id="projectName" name="projectName"--%>
                       <%--class="form-inline" value="${searchParams['projectName']}">--%>

                <div class="buttons pull-right" style="margin-left:15px;">
                    <a class="btn " onclick="btnSubmit();">按项目分析</a>
                    <a class="btn " onclick="exportExcel();">下载</a>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-bordered table-advance table-hover">
        <!--  <thead> -->
        <tr class="info">
            <td width="100" style="text-align:center">转化率</td>
            <td width="100" style="text-align:center">约看</td>
            <td width="100" style="text-align:center">到访</td>
            <td width="100" style="text-align:center">认筹</td>
            <td width="100" style="text-align:center">认购</td>
            <td width="100" style="text-align:center">签约</td>
            <td width="100" style="text-align:center">退房</td>
        </tr>
        <!-- </thead> -->
        <c:forEach items="${countList}" var="item">
            <tr>
                <td nowrap="nowrap" style="text-align:center;background-color: #d9edf7;"><c:out
                        value="${item[0]}"></c:out></td>
                <td nowrap="nowrap" style="text-align:center"><c:out value="${item[1]}"></c:out></td>
                <td nowrap="nowrap" style="text-align:center"><c:out value="${item[2]}"></c:out></td>
                <td nowrap="nowrap" style="text-align:center"><c:out value="${item[3]}"></c:out></td>
                <td nowrap="nowrap" style="text-align:center"><c:out value="${item[4]}"></c:out></td>
                <td nowrap="nowrap" style="text-align:center"><c:out value="${item[5]}"></c:out></td>
                <td nowrap="nowrap" style="text-align:center"><c:out value="${item[6]}"></c:out></td>
            </tr>
        </c:forEach>
        <%-- 	<tr>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="约看"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <c:choose>
                            <c:when test="${countMap['1'] eq 0}">
                             <td nowrap="nowrap" style="text-align:center">-</td>
                             <td nowrap="nowrap" style="text-align:center">-</td>
                             <td nowrap="nowrap" style="text-align:center">-</td>
                             <td nowrap="nowrap" style="text-align:center">-</td>
                             <td nowrap="nowrap" style="text-align:center">-</td>
                          </c:when>
                         <c:otherwise>
                             <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['2'] div countMap['1']} " maxFractionDigits="1"/>
                               </td>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['3'] div countMap['1']} " maxFractionDigits="1"/>
                               </td>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['4'] div countMap['1']} " maxFractionDigits="1"/>
                               </td>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['5'] div countMap['1']} " maxFractionDigits="1"/>
                               </td>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['6'] div countMap['1']} " maxFractionDigits="1"/>
                               </td>
                         </c:otherwise>
                 </c:choose>
         </tr>
         <tr>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="到访"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <c:choose>
                            <c:when test="${countMap['2'] eq 0}">
                             <td nowrap="nowrap" style="text-align:center">-</td>
                             <td nowrap="nowrap" style="text-align:center">-</td>
                             <td nowrap="nowrap" style="text-align:center">-</td>
                             <td nowrap="nowrap" style="text-align:center">-</td>
                          </c:when>
                         <c:otherwise>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['3'] div countMap['2']} " maxFractionDigits="1"/>
                               </td>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['4'] div countMap['2']} " maxFractionDigits="1"/>
                               </td>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['5'] div countMap['2']} " maxFractionDigits="1"/>
                               </td>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['6'] div countMap['2']} " maxFractionDigits="1"/>
                               </td>
                         </c:otherwise>
                 </c:choose>
         </tr>
         <tr>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="认筹"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <c:choose>
                            <c:when test="${countMap['3'] eq 0}">
                             <td nowrap="nowrap" style="text-align:center">-</td>
                             <td nowrap="nowrap" style="text-align:center">-</td>
                             <td nowrap="nowrap" style="text-align:center">-</td>
                          </c:when>
                         <c:otherwise>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['4'] div countMap['3']} " maxFractionDigits="1"/>
                               </td>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['5'] div countMap['3']} " maxFractionDigits="1"/>
                               </td>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['6'] div countMap['3']} " maxFractionDigits="1"/>
                               </td>
                         </c:otherwise>
                 </c:choose>
         </tr>
         <tr>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="认购"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <c:choose>
                            <c:when test="${countMap['4'] eq 0}">
                             <td nowrap="nowrap" style="text-align:center">-</td>
                             <td nowrap="nowrap" style="text-align:center">-</td>
                          </c:when>
                         <c:otherwise>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['5'] div countMap['4']} " maxFractionDigits="1"/>
                               </td>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['6'] div countMap['4']} " maxFractionDigits="1"/>
                               </td>
                         </c:otherwise>
                 </c:choose>
         </tr>
         <tr>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="签约"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <c:choose>
                            <c:when test="${countMap['5'] eq 0}">
                             <td nowrap="nowrap" style="text-align:center">-</td>
                          </c:when>
                         <c:otherwise>
                               <td nowrap="nowrap" style="text-align:center">
                               <fmt:formatNumber type="number" value="${countMap['6'] div countMap['5']} " maxFractionDigits="1"/>
                               </td>
                         </c:otherwise>
                 </c:choose>
         </tr>
         <tr>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="退房"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
                 <td nowrap="nowrap" style="text-align:center"><c:out value="-"></c:out></td>
         </tr> --%>
    </table>
</div>
<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script type="text/javascript">
    $(document).ready(function () {

        var startTime = $("#startTime");
        var endTime = $("#endTime");
        endTime.bind("focus", function () {
            WdatePicker({startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d-1}'});
        });
        startTime.bind("focus", function () {
            WdatePicker({
                startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d-1}',
                onpicked: function () {
                    WdatePicker({
                        /* doubleCalendar: true, */
                        startDate: "%y-{%M-1}-%d",
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        maxDate: '%y-%M-{%d-1}',
                        el: 'endTime'
                    })
                }
            });
        });

        $("#dateViewType").change(function () {
            var val = $(this).val();
            $(".mydate").val("");
            if (val == 1) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-{%d-1}'});
                });
            } else if (val == 2) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({isShowWeek: true, maxDate: '%y-%M-{%d-1}'});
                });
            } else {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-{%d-1}'});
                });
            }
            setTime();
        });


        $('#project').multiselect({
            includeSelectAllOption: true,
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 320,
            numberDisplayed: 2,
            filterPlaceholder: '请输入项目名',
            includeSelectAllOption: false,
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择项目 ';
                } else if (options.length >= 1) {
                    return '已选' + options.length + '个 ';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }
            },
            /*  label: function(element) {
             return "<label style='margin-top:7px;'>"+$(element).html()+"</label>";
             }, */
            optionLabel: function (element) {
                return $(element).html();
            },
            /*  optionClass: function(element) {
             return "aa";
             }, */
            onInitialized: function (select, container) {
                var selectedOptions = $('#project option:selected');

                if (selectedOptions.length >= 1) {
                    var nonSelectedOptions = $('#project option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#project').siblings('.multiselect-container');
                    nonSelectedOptions.each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                }
                else {
                    var dropdown = $('#project').siblings('.multiselect-container');
                    $('#project option').each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            },
            onChange: function (option, checked) {
                var selectedOptions = $('#project option:selected');

                if (selectedOptions.length >= 1) {
                    var nonSelectedOptions = $('#project option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#project').siblings('.multiselect-container');
                    nonSelectedOptions.each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                }
                else {
                    var dropdown = $('#project').siblings('.multiselect-container');
                    $('#project option').each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            }
        });

        setTime();
    })

    function btnSubmit() {
        var tmp = ",";
        var tmpName = ",";
        $("#project").find("option:selected").each(function () {
            tmp = tmp + $(this).val() + ",";
            tmpName = tmpName + $(this).text() + ",";
        });
        if (tmp == ",") {
            House365Util.createModal("未选择项目", "请选择项目", function () {
            });
            return;
        }

        $("#projectIds").val(tmp);
        $("#projectNames").val(tmpName);
        $('#filterForm').submit();
    }

    function exportExcel() {
        document.filterForm.action = "${ctx}/statistic/projectTransformExcel";
        filterForm.submit();
        document.filterForm.action = "${ctx}/statistic/projectTransform";
    }


</script>
</body>
</html>
