<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid" action="${ctx}/role/updateInfo/${entity.id}" method="post">
    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/">首页</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    编辑
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <input id="accid" type="hidden" name="entity.accId" value="${entity.accId}">
    <div class="row${fluid}">
        <div class="span10 offset1">
            <shiro:hasPermission name="USER_EDIT">
                <div class="portlet-header">
                    <div class="operation-btn pull-right">
                        <c:choose>
                            <c:when test="${action=='edit'}">
                                <button class="btn blue" type="submit"><i
                                        class="icon-save"></i>&nbsp;保存
                                </button>
                                <a href="${ctx}/user/${entity.id}" class="btn gray"><i
                                        class="icon-mail-reply"></i>&nbsp;取消</a>
                            </c:when>
                            <c:when test="${action=='create'}">
                                <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                                <a href="${ctx}/user/?search_EQ_deptId=${sessionTreeDept}" class="btn gray"><i
                                        class="icon-mail-reply"></i>&nbsp;返回</a>
                            </c:when>
                            <c:otherwise>
                                <a href="${ctx}/user/${entity.id}?action=edit" class="btn blue"><i
                                        class="icon-edit"></i>&nbsp;编辑</a>
                                <a href="${ctx}/user/?search_EQ_deptId=${sessionTreeDept}" class="btn gray"><i
                                        class="icon-mail-reply"></i>&nbsp;返回</a>
                            </c:otherwise>
                        </c:choose>
                    </div>
                </div>
            </shiro:hasPermission>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        编辑
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">用户名<span style="color: red;">*</span>:</label>
                            <div class="controls">
                                <span class="inline">${entity.name}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">手机号<font style="color: red;">*</font>:</label>
                            <div class="controls">
                                <input id="hotlinephone" type="hidden" name="entity.hotlinephone"
                                       value="${entity.hotlinephone}">
                                <c:if test="${not empty entity.hotlinephone}">
                                    <input type="text" id="entity_mobile" readonly
                                           name="entity.mobile" class="required mobile"
                                           value="${entity.mobile}"/>
                                    <a onclick="bindHotline(${entity.id})" href="javascript:void(0)" id="bindhotline">
                                        解除绑定
                                    </a>
                                </c:if>

                                <c:if test="${empty entity.hotlinephone}">
                                    <input type="text" id="entity_mobile"
                                           name="entity.mobile" class="required mobile"
                                           value="${entity.mobile}"/>
                                    <a onclick="bindHotline(${entity.id})" href="javascript:void(0)" id="bindhotline">
                                        生成400短号
                                    </a>
                                </c:if>

                                <span id="hotlinenum">&nbsp;4008908365&nbsp;${entity.hotlinephone}</span>
                                <font color="red"><form:errors path="userVo.entity.mobile"/></font>
                                <!--新增下载二维码 -->
                                <c:if test="${not empty entity.hotlinephone}">
                                    <input class="btn blue" type="button" onclick="downLoadCallCode(${entity.id})" value="下载一键呼二维码">
                                </c:if>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">姓名:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity_realName"
                                               name="entity.realName" class="required" maxlength="24"
                                               value="${entity.realName}"/>
                                        <font color="red"><form:errors path="userVo.entity.realName"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.realName}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">业务专长:</label>
                            <div class="controls">
                                <input type="text" id="entity_goodat" name="entity.goodat" maxlength="20"
                                       value="${entity.goodat}"/>
                                <span color="red"><form:errors path="userVo.entity.goodat"/></span>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">个人介绍:</label>
                            <div class="controls">
                                        <textarea class="span9" id="entity_description" name="entity.description"
                                                  rows="3" maxlength="120"
                                                  placeholder="个人介绍">${entity.description}</textarea>
                                <span color="red"><form:errors path="userVo.entity.description"/></span>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <%--<label class="control-label">${entity.headImgURL}</label>--%>
                            <label class="control-label">个人头像:</label>
                            <div class="controls">
                                <input id="headImgURL" type="hidden" name="entity.headImgURL"
                                       value="${entity.headImgURL}">
                                <tags:imageSection resourceId="${entity.id}"
                                                   resourceType="hgs_user_headImg"
                                                   bizType="1" editAble="true" title="个人头像" maxSize="1"/>
                                <span class="f12 col_7f pl10">图片建议尺寸：300*300</span>

                                <span color="red"><form:errors path="userVo.entity.headImgURL"/></span>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">全身照:</label>
                            <div class="controls">
                                <input id="fullImgURL" type="hidden" name="entity.fullImgURL"
                                       value="${entity.fullImgURL}">
                                <tags:imageSection resourceId="${entity.id}"
                                                   resourceType="hgs_user_fullImg"
                                                   bizType="2" editAble="true" title="全身照" maxSize="1"/>
                                <span class="f12 col_7f pl10">图片建议尺寸：172*230</span>

                                <span color="red"><form:errors path="userVo.entity.fullImgURL"/></span>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">微信:</label>
                            <div class="controls">
                                <input id="wxCodeImgUrl" type="hidden" name="entity.wxCodeImgUrl"
                                       value="${entity.wxCodeImgUrl}">
                                <tags:imageSection resourceId="${entity.id}"
                                                   resourceType="wx_code_imgUrl"
                                                   bizType="3" editAble="true" title="微信二维码" maxSize="1"/>
                                <span class="f12 col_7f pl10">图片建议尺寸：172*230</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">微信号:</label>
                            <div class="controls">
                                <input type="text" id="wxNumber" name="entity.wxNumber" maxlength="20"
                                       value="${entity.wxNumber}"/>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">归属部门:</label>
                            <div class="controls">
                                <span class="inline">${deptName}&nbsp;</span>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">权限组：</label>
                            <div class="controls">
                                <span class="inline">${roleName}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">职位:</label>
                            <div class="controls">
                                <input type="text" id="entity_position"
                                       name="entity.position" class="required" maxlength="100"
                                       value="${entity.position}"/>
                                <span color="red"><form:errors path="userVo.entity.position"/></span>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">创建时间:</label>
                            <div class="controls">
                                <fmt:formatDate value='${entity.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">回拨短号:</label>
                            <div class="controls">
                                <input type="text" id="entity_cornet" maxlength="11"
                                       value="${entity.cornet}"/>
                                <input type="button" onclick="bindCornet()" value="绑定"/>
                                <span color="red"><form:errors path="userVo.entity.cornet"/></span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">初始带看次数:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${entity.defaultVisit!='0'}">
                                        <input type="text" id="entity_defaultVisit" name="entity.defaultVisit"
                                               maxlength="11"
                                               value="${entity.defaultVisit}"/>
                                    </c:when>
                                    <c:otherwise>
                                        <input type="text" id="entity_defaultVisit" name="entity.defaultVisit"
                                               maxlength="11"
                                               value=""/>
                                    </c:otherwise>
                                </c:choose>
                                <span color="red"><form:errors path="userVo.entity.defaultVisit"/></span>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
            <div class="portlet-header">
                <div class="operation-btn">
                    <input class="btn blue" type="button" onclick="commitForm()" value="保存">
                    </input>
                    <%--<input class="btn blue" type="button" onclick="revertPassword()" value="重置密码">--%>
                    <%--</input>--%>
                </div>
            </div>
        </div>

    </div>

</form>

<script>

    function bindHotline(id) {
        if ($("#hotlinephone").val()) {
            $.ajax({
                url: "${ctx}/role/unbindHotline",
                data: {
                    userId: id
                },
                success: function (data) {
                    if (data.result == '1') {
                        window.location.reload();
                    } else {
                        alert(data.msg);
                    }
                }
            });
        } else {
            $.ajax({
                url: "${ctx}/role/bindHotline",
                data: {
                    userId: id
                },
                success: function (data) {
                    if (data.result != '0') {
                        window.location.reload();
                    } else {
                        alert(data.msg);
                    }
                }
            });
        }
    }

    function bindCornet() {
        var cornet = $("#entity_cornet").val();
        $.ajax({
            url: "${ctx}/role/bindCornet",
            data: {
                cornet: cornet
            },
            success: function (data) {
                alert(data.msg);
            }
        });
    }

    function commitForm() {
        var phone = $("#entity_mobile").val();
        var name = $("#entity_realName").val();
        var position = $("#entity_position").val();
        var description = $("#entity_description").val();
        var defaultVisit = $("#entity_defaultVisit").val();
        var wxNumber = $("#wxNumber").val();
        var wxCodeImgUrl = $("#wxCodeImgUrl").val();
        if (description.length > 200) {
            House365Util.createModal("提示", "个人介绍不能超过200个字", function () {
                $("#entity_description").focus();
            });
            return false;
        }

        if (phone != "" && !checkMobile(phone)) {
            House365Util.createModal("提示", "号码格式不正确", function () {
                $("#entity_mobile").focus();
            });
            return false;
        }
        if (description.length > 200) {
            House365Util.createModal("提示", "个人介绍不能超过200个字", function () {
                $("#entity_description").focus();
            });
            return false;
        }

        if (defaultVisit != "" && !checkDefaultVisit(defaultVisit)) {
            House365Util.createModal("提示", "请填入小于等于50的正整数", function () {
                $("#entity_defaultVisit").focus();
            });
            return false;
        }
        if (wxNumber == null || wxNumber == '') {
            alert("请填写微信号");
            return false;
        }

        $("#input_form").submit();
    }

    function checkMobile(val) {
        var pattern = /(^(([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)|(^0{0,1}1[3|4|5|6|7|8|9][0-9]{9}$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }
    }

    function checkDefaultVisit(val) {
        var pattern = /(^[1-9]$)|(^[1-4][0-9]$)|(^50$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }
    }
    // 下载一键呼二维码
    function downLoadCallCode(id){
        window.open("${ctx}/role/downLoadCallCode?userId="+id);
    }
</script>

</body>

</html>
