<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>置业报告资质</title>
    <!--引入CSS-->
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>广告图</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/repoetattach/adAttach" method="get">
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th class="span1" width="50">序号</th>
            <th class="span2" width="100">名称</th>
            <th class="span2" width="100">预览图</th>
            <th class="span2" width="100">链接</th>
            <th class="span2" width="100">操作</th>
        </tr>
        </thead>
        <c:forEach items="${dataList}" var="attachment">
            <tr>
                <td class="span1">
                    <c:if
                            test="${null ne attachment.id && '' ne attachment.id}">
                        <c:out value="${attachment.id}"/>
                    </c:if>
                    <c:if test="${null eq attachment.id || '' eq attachment.id}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${null ne attachment.name && '' ne attachment.name}">
                        <c:out value="${attachment.name}"/>
                    </c:if>
                    <c:if test="${null eq attachment.name || '' eq attachment.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <div class="controls">
                        <input id="fullImgURL" type="hidden" name="entity.url" value="${attachment.url}">
                        <tags:imageSection resourceId="${attachment.id}"
                                           resourceType="report_attach_ad"
                                           bizType="3" editAble="true" title="广告图" maxSize="1"/>
                        <span class="f12 col_7f pl10">图片建议尺寸：140*140</span>
                    </div>
                </td>
                <td class="span2">
                        <%--<c:out value="${attachment.link}"/>--%>
                    <input id="link" value="${attachment.link}">
                </td>
                <td class="span2">
                    <div class="btn-group btn-group-sm">
                        <button type="button" class="btn btn-default"
                                onclick="update(${attachment.id})">更新
                        </button>
                    </div>
                </td>
            </tr>
        </c:forEach>
    </table>
</div>

<script type="text/javascript">

    function addAttach(projectId) {
        House365Util.createRemoteModal("", "${ctx}/project/addAttach/" + projectId, null, function () {
            var remark = $("#remark").val();
            if (remark && remark.length > 64) {
                alert("备注不能超过64个字!");
                return false;
            }
            $("#addAttachForm").submit();
        });
    }

    var update = function (id) {
        var link = $("#link").val();
        var data = {
            id: id,
            link: link
        };
        data = JSON.stringify(data);
        console.log(data);
        $.ajax({
            url: '${ctx}/repoetattach/update',
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    alert("更新成功");
                    window.location.reload();
                } else {
                    alert(result.errorMessage);
                }
            }
        });
    };

</script>
</body>
</html>
