<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>项目列表</title>
    <!--引入CSS-->
    <style>
        .show-image {
            cursor: pointer;
        }

        .uploadmain .delete {
            position: absolute;
            right: -10px;
            top: -10px;
            cursor: pointer;
            border-radius: 50%;
            background: rgba(0, 0, 0, .5) url(${static_common}/upload/image/delete.png) no-repeat center;
            width: 20px;
            height: 20px;
            background-size: 10px
        }

    </style>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <!-- <li><a href="/house365-hmc-web/">首页</a> <span class="divider"></span></li> -->
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>项目图片列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm"
                  action="${ctx}/project/attachments?projectId=${projectId}" method="get">
                <input type="hidden" id="projectId" name="projectId" value="${projectId}"/>
                <input id="type" type="hidden" value="hgs_project"/>

                <input type="text" name="search_LIKE_name" value="${param['search_LIKE_name']}"
                       class="m-wrap small span2" placeholder="项目图片名称">
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="#" class="btn blue pull-right" onclick="showUpload()" title="新增">新增</a>
                    <%--<a href="#" class="btn blue pull-right" onclick="addAttach('${projectId}')" title="新增">新增1</a>--%>
                </div>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th class="span1" width="50">序号</th>
            <th class="span2" width="100">名称</th>
            <th class="span2" width="100">预览图</th>
            <th class="span2" width="100">上传人</th>
            <th class="span2" width="100">上传时间</th>
            <th class="span2" width="100">操作</th>
        </tr>
        </thead>
        <c:forEach items="${attachments}" var="attachment">
            <tr>
                <td class="span1">
                    <c:if
                            test="${null ne attachment.id && '' ne attachment.id}">
                        <c:out value="${attachment.id}"/>
                    </c:if>
                    <c:if test="${null eq attachment.id || '' eq attachment.id}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${null ne attachment.name && '' ne attachment.name}">
                        <c:out value="${attachment.name}"/>
                    </c:if>
                    <c:if test="${null eq attachment.name || '' eq attachment.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${null ne attachment.remotePath && '' ne attachment.remotePath}">
                        <%--<img class="attach-img img-show" src="${attachment.remotePath}"/>--%>
                        <img class="show-image" width="200px" src="${attachment.remotePath}"
                             onclick="showImage('${attachment.remotePath}')"/>
                    </c:if>
                    <c:if test="${null eq attachment.remotePath || '' eq attachment.remotePath}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${null ne attachment.remark && '' ne attachment.remark}">
                        <c:out value="${attachment.remark}"/>
                    </c:if>
                    <c:if test="${null eq attachment.remark || '' eq attachment.remark}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <c:if test="${null ne attachment.createTime && '' ne attachment.createTime}">
                        <fmt:formatDate value="${attachment.createTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
                    </c:if>
                    <c:if test="${null eq attachment.createTime || '' eq attachment.createTime}">
                        &nbsp;
                    </c:if>
                </td>
                <td class="span2">
                    <div class="btn-group btn-group-sm">
                        <button type="button" class="btn btn-default"
                                onclick="deleteById(${attachment.id})">删除
                        </button>
                    </div>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>

<div class="uploadmain">
    <div class="uploadmask"></div>
    <div class="uploadmain">
        <div class="updiv">
            图片上传：
            <div class="upimg">
                <span>选择文件</span>
                <input type="file" id="upgteimg" value="" multiple/>
            </div>
        </div>
        <div id="showimg">
            <ul id="showui" class="imglist"></ul>
            <div id="showinput"></div>
        </div>
        <div class="btnlist">
            <button class="btn cblue" id="submit">确定</button>
            <button class="btn cgray" onclick="cancel()">取消</button>
        </div>
    </div>
</div>

<link rel="stylesheet" type="text/css" href="${static_common}/upload/css/upload.css"/>
<script src="${static_common}/upload/js/jquery.min.js"></script>
<script type="text/javascript" src="${static_common}/upload/js/updateimg.js"></script>
<script type="text/javascript">

    function addAttach(projectId) {
        House365Util.createRemoteModal("", "${ctx}/project/addAttach/" + projectId, null, function () {
            var remark = $("#remark").val();
            if (remark && remark.length > 64) {
                alert("备注不能超过64个字!");
                return false;
            }
            $("#addAttachForm").submit();
        });
    }

    var deleteById = function (selectedId) {
        House365Util.createModal("提示", "您确定要删除该项目图片吗？", function () {
            $.ajax({
                url: '${ctx}/image/delete/' + selectedId,
                type: "GET",
                success: function () {
                    window.location.reload();
                }
            });
        });
    };

    var showImage = function (imgUrl) {
        var content = "<img src='" + imgUrl + "'/>"
        House365Util.createModal("图片", content);
    };

    function showUpload() {
        $(".uploadmain").show();
    }

    function cancel() {
        $(".uploadmain").css('display', 'none');
    }

</script>
</body>
</html>
