<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <c:if test="${not empty managerName}">
        <title>${managerName}的客户</title>
    </c:if>
    <c:if test="${empty managerName}">
        <title>平台管理客户</title>
    </c:if>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>
<link rel="stylesheet" type="text/css" href="${static_common}/label/tag.css"/>

<style>
    .container-fluid {
        min-width: 1440px;
    }

    .dataTables_info {
        position: absolute;
        right: 753px;
        top: 77px;
    }

    .inputSearch {
        margin-right: 20px;
    }

    .table-complex {
        background-color: #f9f9f9;
    }

    .table-star {
        background-color: #FFEB3B;
    }

    .lastChoseCustomer {
        background-color: #91bfbf;
    }

    .numbers {
        font-size: 14px;
        color: #AAB5BC;
        font-weight: 600;
        text-transform: uppercase;
    }

    .font-blue-sharp {
        color: #5C9BD1 !important;
    }

    .dashboard-stat2 {
        -webkit-border-radius: 2px;
        -moz-border-radius: 2px;
        -ms-border-radius: 2px;
        -o-border-radius: 2px;
        border-radius: 2px;
        background: #eff3f8;
        padding: 15px 15px 30px;
        margin-bottom: 20px;
    }

    .dashboard-stat2 .display .number {
        float: left;
        display: inline-block;
    }

    .dashboard-stat2 .display .number small {
        font-size: 14px;
        color: #AAB5BC;
        font-weight: 600;
        text-transform: uppercase;
    }

    .dashboard-stat2 .display .number h5 {
        margin: 0 0 2px;
        padding: 0;
        font-size: 20px;
        font-weight: 400;
    }

    .dashboard-stat2, .dashboard-stat2 .display {
        margin-bottom: 20px;
    }

    .dashboard-stat2 .display .icon {
        display: inline-block;
        float: right;
        padding: 0;
    }

    .dashboard-stat2 .display .icon > i {
        color: #cbd4e0;
        font-size: 26px;
    }

    input[type='text'] {
        margin-right: 15px;
    }

    .num3 {
        background: green;
        color: #fff;
        padding: 1px 6px;
        border-radius: 10px;
    }

    .tag-item {
        color: white;
    }

    #labelModel, #myModal {
        display: none;
    }

    .temp {
        border: 1px solid #cccccc;
        width: 430px !important;
        height: 160px !important;
        position: relative;
        top: -26px;
        left: 81px;
    }

    .bt {
        padding: 0 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
        margin: 0 5px;
        display: inline-block;
        height: 30px;
        line-height: 30px;
    }

    .bat {
        padding: 0 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
        margin: 0 5px;
        display: inline-block;
        height: 30px;
        line-height: 30px;
    }

    .bat2 {
        padding: 0 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
        margin: 0 5px;
        display: inline-block;
        height: 30px;
        line-height: 30px;
    }

    .color_999 {
        border: 1px solid #999;
        color: #999;
    }

    .color_d9534f {
        border: 1px solid #d9534f;
        color: #d9534f;
    }

    .color_f0ad4e {
        border: 1px solid #f0ad4e;
        color: #f0ad4e;
    }

    .color_5cb85c {
        border: 1px solid #5cb85c;
        color: #5cb85c;
    }

    .color_5bc0de {
        border: 1px solid #5bc0de;
        color: #5bc0de;
    }

    .color_0275d8 {
        border: 1px solid #0275d8;
        color: #0275d8;
    }

    .color_663399 {
        border: 1px solid #663399;
        color: #663399;
    }

    .bt_last {
        background-color: #f0f0f0 !important;
        border: none !important;
        background-image: none !important;
    }

    .chosen-container {
        margin-left: 7px !important;
        width: 96px !important;
    }

    .shouc {
        position: absolute;
        right: 12px;
    }

    .table td.mangerItem.mangerlist {
        overflow: hidden;
        padding: 0;
        width: 33%;
    }

    .mangerId_avar2 {
        overflow: hidden;
        width: 75px;
        height: 16px;
        background: url("${static_common}/img/creater.png") left center no-repeat;
        -webkit-background-size: 12px 14px;
        background-size: 18px 19px;
        text-indent: 20px;
        line-height: 16px;
        text-overflow: ellipsis;
        margin-left: -3px;
    }
</style>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                <c:if test="${not empty managerName}">
                    ${managerName}的客户
                </c:if>
                <c:if test="${empty managerName}">
                    平台管理客户
                </c:if>
            </li>
            <li style="float: right;margin-top: -5px;">
                <button type="button" class="btn btn-default"
                        onclick="window.open('${ctx}/platformmanagement/newCustomer','_blank')">添加客户
                </button>
            </li>
        </ul>
    </div>
    <input type="hidden" id="markIds" name="markIds" value=""/>
</div>

<form id="filterForm" class="form-inline filterForm" action="${ctx}/platformmanagement/myPlatformCustomer" method="get"
      style="margin: 11px 0 6px 0;">
    <div class="row-fluid"
         style="border-style: solid;border-width: thin;border-color: #d5d5d5;padding: 20px;margin-bottom: 20px;line-height: 43px;">
        <div class="span12">

            添加时间： <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text"
                         name="search_GTE_createTimeStart"
                         id="search_GTE_createTimeStart" value="${param['search_GTE_createTimeStart']}"
                         class="m-wrap small span2">至
            <input style="width: 7rem;margin-left: 15px;border: 1px solid #d5d5d5;" type="text"
                   name="search_LTE_createTimeEnd"
                   id="search_LTE_createTimeEnd" value="${param['search_LTE_createTimeEnd']}"
                   class="m-wrap small span2"
            >

            <span id="createTimeRecentSeven"
                  style="cursor: pointer;<c:if test="${'2' eq timePeriod}">color: #30A3DE;</c:if>"
                  onclick="createTimeClick('2')">近7天</span>&nbsp;&nbsp;
            <span id="createTimeRecentThirty"
                  style="cursor: pointer;<c:if test="${'1' eq timePeriod}">color: #30A3DE;</c:if>"
                  onclick="createTimeClick('1')">30天</span>&nbsp;&nbsp;
            <span id="createTimeAll"
                  style="cursor: pointer;<c:if test="${'0' eq timePeriod}">color: #30A3DE;</c:if>"
                  onclick="createTimeClick('0')">全部</span>&nbsp;&nbsp;
            &nbsp;&nbsp;

            <select style="width: 6rem" name="search_EQ_customTimeType" id="search_EQ_customTimeType">
                <option value="1"
                        <c:if test="${'1' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                    回访时间
                </option>
                <option value="2"
                        <c:if test="${'2' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                    约看时间
                </option>
                <option value="3"
                        <c:if test="${'3' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                    到访时间
                </option>
                <option value="4"
                        <c:if test="${'4' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                    认筹时间
                </option>
                <option value="5"
                        <c:if test="${'5' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                    认购时间
                </option>
                <option value="6"
                        <c:if test="${'6' eq param['search_EQ_customTimeType']}">selected="selected"</c:if>>
                    签约时间
                </option>
            </select>
            <input style="width: 7rem;border: 1px solid #d5d5d5;" type="text"
                   name="search_GTE_customTimeStart"
                   id="search_GTE_customTimeStart" value="${param['search_GTE_customTimeStart']}"
                   class="m-wrap small span2"
            >至
            <input style="width: 7rem;margin-left: 15px;;border: 1px solid #d5d5d5;" type="text"
                   name="search_LTE_customTimeEnd"
                   id="search_LTE_customTimeEnd" value="${param['search_LTE_customTimeEnd']}"
                   class="m-wrap small span2"
            >

            购房意向：<select style="width: 6rem" name="search_EQ_buyIntention" id="search_EQ_buyIntention">
            <option value="all">
                全部
            </option>
            <option value="1"
                    <c:if test="${'1' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                A
            </option>
            <option value="2"
                    <c:if test="${'2' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                B
            </option>
            <option value="3"
                    <c:if test="${'3' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                C
            </option>
            <option value="4"
                    <c:if test="${'4' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                D
            </option>
            <option value="5"
                    <c:if test="${'5' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                E
            </option>
        </select>&nbsp;&nbsp;&nbsp;&nbsp;
            <br/>
            客户姓名：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_LIKE_name"
                        name="search_LIKE_name" value="${param['search_LIKE_name']}"
                        class="m-wrap small" placeholder="客户姓名">&nbsp;&nbsp;&nbsp;&nbsp;
            客户手机：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_LIKE_phone"
                        name="search_LIKE_phone" value="${param['search_LIKE_phone']}"
                        class="m-wrap small" placeholder="客户手机">&nbsp;&nbsp;&nbsp;&nbsp;
            置业顾问：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_LIKE_managerName"
                        name="search_LIKE_managerName" value="${param['search_LIKE_managerName']}"
                        class="m-wrap small" placeholder="置业顾问">&nbsp;&nbsp;&nbsp;&nbsp;
            回访记录：<input type="text" id="search_LIKE_callbackLog" style="border: 1px solid #d5d5d5;"
                        name="search_LIKE_callbackLog" value="${param['search_LIKE_callbackLog']}"
                        class="m-wrap small" placeholder="回访记录">


            客户状态：<select style="width: 6rem" name="search_EQ_platProjectStatus" id="search_EQ_platProjectStatus">
            <option value="">
                全部
            </option>
            <option value="7"
                    <c:if test="${'7' eq param['search_EQ_platProjectStatus']}">selected="selected"</c:if>>
                跟进中
            </option>
            <option value="8"
                    <c:if test="${'8' eq param['search_EQ_platProjectStatus']}">selected="selected"</c:if>>
                回公海
            </option>
            <option value="1"
                    <c:if test="${'1' eq param['search_EQ_platProjectStatus']}">selected="selected"</c:if>>
                约看
            </option>
            <option value="2"
                    <c:if test="${'2' eq param['search_EQ_platProjectStatus']}">selected="selected"</c:if>>
                到访
            </option>
            <option value="3"
                    <c:if test="${'3' eq param['search_EQ_platProjectStatus']}">selected="selected"</c:if>>
                认筹
            </option>
            <option value="4"
                    <c:if test="${'4' eq param['search_EQ_platProjectStatus']}">selected="selected"</c:if>>
                认购
            </option>
            <option value="5"
                    <c:if test="${'5' eq param['search_EQ_platProjectStatus']}">selected="selected"</c:if>>
                签约
            </option>
            <option value="6"
                    <c:if test="${'6' eq param['search_EQ_platProjectStatus']}">selected="selected"</c:if>>
                退房
            </option>
        </select>&nbsp;&nbsp;&nbsp;&nbsp;

            部门：<select style="width: 6rem" name="search_EQ_dept" id="search_EQ_dept">
            <option value="">
                全部
            </option>
            <option value="1"
                    <c:if test="${'1' eq param['search_EQ_dept']}">selected="selected"</c:if>>
                直销一部
            </option>
            <option value="2"
                    <c:if test="${'2' eq param['search_EQ_dept']}">selected="selected"</c:if>>
                直销二部
            </option>
            <option value="3"
                    <c:if test="${'3' eq param['search_EQ_dept']}">selected="selected"</c:if>>
                直销三部
            </option>
        </select>&nbsp;&nbsp;&nbsp;&nbsp;
            <%--</c:if>--%>
            是否星标：<select style="width: 6rem" name="search_EQ_isPtStar" id="search_EQ_isPtStar">
            <option value="1"
                    <c:if test="${'1' eq param['search_EQ_isPtStar']}">selected="selected"</c:if>>
                全部
            </option>
            <option value="2"
                    <c:if test="${'2' eq param['search_EQ_isPtStar']}">selected="selected"</c:if>>
                是
            </option>
            <option value="3"
                    <c:if test="${'3' eq param['search_EQ_isPtStar']}">selected="selected"</c:if>>
                否
            </option>
          </select>


                平台人：<input style="width: 8rem;border: 1px solid #d5d5d5;" type="text" id="search_LIKE_createrName"
                           name="search_LIKE_createrName" value="${param['search_LIKE_createrName']}"
                           class="m-wrap small" placeholder="请输入添加人姓名">&nbsp;


            活动来源：
            <select width: 6rem name="search_EQ_actSource" id="search_EQ_actSource">
                <c:forEach items="${sources}" var="source">
                    <option value="${source.sourceName}"
                            <c:if test="${source.sourceName eq param['search_EQ_actSource']}">selected="selected"</c:if>>${source.sourceName}</option>
                </c:forEach>
            </select>

            <div style="float: right">
                <button type="button" class="btn btn-default"
                        onclick="$('#filterForm').submit();">搜索
                </button>&nbsp;&nbsp;&nbsp;&nbsp;
                <button type="button" class="btn btn-default"
                        onclick="resetForm()">重置
                </button>
            </div>
        </div>
    </div>

    <div class="page-container">
        <input type="hidden" id="managerId" name="managerId" value="${param['managerId']}"/>
        <input type="hidden" id="type" name="type" value="${param['type']}"/>
        <input type="hidden" name="summaryType" value="${summaryType}"/>
        <input type="hidden" id="currentUserId" name="currentUserId" value="${currentUserId}"/>
        <input type="hidden" id="timePeriod" name="timePeriod" value="${timePeriod}"/>

        <div class="row-fluid">
            <ul class="nav nav-tabs" style="margin-bottom: 0;position: relative;">
                <%--</c:if>--%>
                <a href="javascript:linkTypeUrl('')">全部</a>

                <li style="float: right;padding-top: 10px;padding-right: 10px;">
                    <select style="width: 120px" name="search_EQ_orderByTime" id="search_EQ_orderByTime"
                            onchange="$('#filterForm').submit();">
                        <option value="1"
                                <c:if test="${'1' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                            添加时间降序
                        </option>
                        <option value="2"
                                <c:if test="${'2' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                            添加时间升序
                        </option>
                        <option value="3"
                                <c:if test="${'3' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                            派工时间降序
                        </option>
                        <option value="4"
                                <c:if test="${'4' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                            派工时间升序
                        </option>
                        <option value="5"
                                <c:if test="${'5' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                            回访时间降序
                        </option>
                        <option value="6"
                                <c:if test="${'6' eq param['search_EQ_orderByTime']}">selected="selected"</c:if>>
                            回访时间升序
                        </option>
                    </select>
                </li>
            </ul>
            <div class="bottomBtn" style="overflow: hidden">
                <div class="checkAll">选择全部：<input type="checkbox" id="memberCheckAll" onclick="checkAll(this)"/></div>
                <shiro:hasPermission name="FUNC:BATCHTRANSFER">
                    <div class="bottomBtnR" onclick="assignManager()">批量转移</div>
                </shiro:hasPermission>
                <div class="bottomBtnR" name="batchDel" onclick="batchDel()">批量删除</div>
            </div>
        </div>
    </div>
</form>
<table class="table table-advance mine">
    <tbody>
    <c:forEach items="${customers}" var="customer" varStatus="vs">
        <tr id="customerId_${customer.id}" class="header expand
                         <c:if test="${customer.star ne 'on' && vs.index%2==0}">table-complex</c:if>
                         <c:if test="${customer.star eq 'on'}">table-star</c:if>">
            <td class="mangerId mangerItem mine">
                <div class="mangerItem__border"></div>
                <input type="checkbox" name="memberCheck" value="${customer.id}"
                       onclick="checkMember(this)">
                <span class="mangerId_num mine">${customer.id}</span>
                <span class="mangerId_name">
                            <c:if test="${null ne customer.name && '' ne customer.name}">
                                <c:choose>
                                    <c:when test="${fn:length(customer.name) > 3}">
                                        <c:out value="${fn:substring(customer.name, 0, 3)}..."/>
                                    </c:when>
                                    <c:otherwise>
                                        <c:out value="${customer.name}"/>
                                    </c:otherwise>
                                </c:choose>
                            </c:if>
                            <c:if test="${null eq customer.name || '' eq customer.name}">
                                &nbsp;
                            </c:if>
                        </span>
                <div class="mangerId_content">
                    <div class="mangerId_phone">
                        <c:if test="${null ne customer.phone && '' ne customer.phone}">
                            <a href="javascript:void(0)" onclick="getCRM(${customer.id})"><c:out
                                    value="${customer.phone}"/></a>
                        </c:if>
                        <c:if test="${null eq customer.phone || '' eq customer.phone}">
                            &nbsp;
                        </c:if>
                    </div>
                    <div class="mangerId_person">
                        <div class="mangerId_avar2" style="float: inherit">
                            <c:out value="${customer.creater}"/>
                        </div>
                        <div class="mangerId_avar"
                             style="float: inherit;display: flex;width: 80%;margin-top: 5px;justify-content: space-between;">
                            <c:if test="${null ne customer.managerName && '' ne customer.managerName}">
                                <c:out value="${customer.managerName}"/>
                            </c:if>
                            <c:if test="${null eq customer.managerName || '' eq customer.managerName}">
                                &nbsp;
                            </c:if>
                            <div class="mangerId_up">
                                <c:choose>
                                    <c:when test="${customer.buyIntention eq '1'}">
                                        A
                                    </c:when>
                                    <c:when test="${customer.buyIntention eq '2'}">
                                        B
                                    </c:when>
                                    <c:when test="${customer.buyIntention eq '3'}">
                                        C
                                    </c:when>
                                    <c:when test="${customer.buyIntention eq '4'}">
                                        D
                                    </c:when>
                                    <c:when test="${customer.buyIntention eq '5'}">
                                        E
                                    </c:when>
                                    <c:otherwise>
                                        待定
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="mangerId_state">
                    <span class="inline">${customer.platCustomerStatus}</span>
                </div>
            </td>
            <td class="mangerlist mangerItem" style="width: 40%">
                <c:if test="${0 ne fn:length(customer.callbackLogEntities)}">
                    <div class="mangerlist__txt" style="width: 60%">
                        <div class="mangerlist__item">
                            <c:forEach items="${customer.callbackLogEntities}" var="callbackLog"
                                       varStatus="index">
                                <p>
                                    <c:if test="${empty callbackLog.content && index.count<=3}">
                                        <c:if test="${empty callbackLog.callRecordId}">
                                            [电话已拨，但未接通或被挂断]
                                        </c:if>
                                        <c:if test="${not empty callbackLog.callRecordId && index.count<=3}">
                                            [语音记录]
                                        </c:if>
                                    </c:if>
                                    <c:if test="${not empty callbackLog.content && index.count<=3}">
                                        <c:choose>
                                            <c:when test="${fn:length(callbackLog.content) > 20}">
                                                <c:out value="${fn:substring(callbackLog.content, 0, 20)}..."/>
                                            </c:when>
                                            <c:otherwise>
                                                <c:out value="${callbackLog.content}"/>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:if>
                                </p>
                            </c:forEach>
                        </div>
                    </div>
                    <div class="mangerlist__date">
                        <div class="mangerlist__dateC">
                            <c:forEach items="${customer.callbackLogEntities}" var="callbackLog"
                                       varStatus="index">
                                <p><c:if test="${index.count<=3}">
                                    <f:formatDate value='${callbackLog.createTime}' pattern='MM-dd HH:mm'/>
                                </c:if>
                                </p>
                            </c:forEach>
                        </div>
                    </div>
                    <div class="mangerlist__record"
                         onclick="showCustomerCallbackLogs('${customer.id}', '${customer.managerId}')">
                        查看回访记录
                    </div>
                </c:if>
                <c:if test="${0 eq fn:length(customer.callbackLogEntities)}">
                    <div class="mangerlist__txt">
                        <div class="mangerlist__item">
                            暂无回访记录！
                        </div>
                    </div>
                    <div class="mangerlist__date">
                        <div class="mangerlist__dateC">
                        </div>
                    </div>
                </c:if>
                <div class="mangerItem__border"></div>
            </td>
            <td class="mangerItem mangerCollect ${customer.star}"
                onclick="toggleCollect(this,'${customer.id}','${customer.createrId}','${customer.star}')">
                <div class="mangerItem__border"></div>
            </td>
            <td class="mangerItem mangerOperate" style="display: table;padding: 0;overflow:visible;">
                <div class="mangerOperate__time" style="right:160px;width:150px;">
                    <c:if test="${null ne customer.bindTime && '' ne customer.bindTime}">
                        派工:<f:formatDate value='${customer.bindTime}'
                                         pattern='MM-dd HH:mm'/>
                    </c:if>
                    <c:if test="${null eq customer.bindTime || '' eq customer.bindTime}">
                        &nbsp;
                    </c:if>
                </div>
                <div class="mangerOperate__time" style="right:0px">
                    <c:if test="${null ne customer.createTime && '' ne customer.createTime}">
                        <f:formatDate value='${customer.createTime}'
                                      pattern='MM-dd HH:mm'/>
                    </c:if>
                    <c:if test="${null eq customer.createTime || '' eq customer.createTime}">
                        &nbsp;
                    </c:if>
                </div>
                <div style="display: table-cell;vertical-align: middle">
                    <c:if test="${customer.hasCustomerProjects}">
                        <div class="mangerOperate__record"
                             onclick="showCustomerProjects('${customer.id}', '${customer.managerId}')"
                             style="position: relative;">
                            约看记录
                            <c:if test="${customer.hasNewCustomerProjects}">
                                <div style="position: absolute; width: 8px;height: 8px;background-color: red;border-radius: 50%;top: 5px;right: -7px;"></div>
                            </c:if>
                        </div>
                    </c:if>
                    <c:if test="${!customer.hasCustomerProjects}">
                        <div class="mangerOperate__record none"
                             style="position: relative;cursor: default;color:grey;">
                            约看记录
                        </div>
                    </c:if>
                    <div class="mangerOperate__detail"
                         onclick="customerInfo(${customer.id}, '${customer.managerId}')">查看详情
                    </div>
                    <%--<div class="mangerOperate__detail"--%>
                         <%--onclick="deleteById(${customer.id})">删除--%>
                    <%--</div>--%>

                </div>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="row-fluid" style="position: relative">
    <house365:newPagination page="${page}"/>
</div>


<script type="text/html" id="customerProjectsTemplate">
    <div class="returnWinList list2">
        <div class="returnWinItem">
            <div class="reportWinItem bold date" style="text-indent: 27px;">约看楼盘</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">案场报备</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">客户状态</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">贷款状态</div>
            <div class="reportWinItem bold" style="width:150px">约看时间</div>
            <div class="reportWinItem bold" style="text-indent: 12px;">操作</div>
        </div>
        {{if customerProjects.length !=0}}
        {{each customerProjects as cp index}}
        <div class="returnWinItem">
            <div class="reportWinItem date" style="text-indent: 27px;">
                <a href="#">{{cp.projectName}}</a>
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                {{if cp.recordedStatus == '1'}}
                <span>案场已报备</span>
                {{else if cp.recordedStatus == '0'}}
                <span>案场未报备</span>
                {{else}}
                <span>无</span>
                {{/if}}
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                {{if cp.status == '1'}}
                <span>约看</span>
                {{else if cp.status == '2'}}
                <span>到访</span>
                {{else if cp.status == '3'}}
                <span>认筹</span>
                {{else if cp.status == '4'}}
                <span>认购</span>
                {{else if cp.status == '5'}}
                <span>签约</span>
                {{else if cp.status == '6'}}
                <span>退房</span>
                {{else}}
                <span>无</span>
                {{/if}}
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                {{if cp.loanStatus == '0'}}
                <span>未办理</span>
                {{else if cp.loanStatus == '1'}}
                <span>申请中</span>
                {{else if cp.loanStatus == '2'}}
                <span>已下款</span>
                {{else if cp.loanStatus == '3'}}
                <span>被拒绝</span>
                {{else if cp.loanStatus == '4'}}
                <span>全款支付</span>
                {{else}}
                <span>无</span>
                {{/if}}
            </div>
            <div class="reportWinItem" style="width:150px">
                <span>{{cp.createTime | dateFormat:'yyyy.MM.dd hh:mm:ss'}}</span>
            </div>
            <div class="reportWinItem" style="text-indent: 12px;">
                <span><a href="#">详情</a></span>
                <span color="red">{{cp.remark}}</span>
            </div>
        </div>
        {{/each}}
        {{else}}
        暂无约看记录
        {{/if}}
    </div>
</script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/customize/js/template.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/customize/js/utils.js"></script>
<script type="text/javascript" src="${ctx}/resources/script/counterup/jquery.waypoints.min.js"></script>
<script type="text/javascript" src="${ctx}/resources/script/counterup/jquery.counterup.min.js"></script>

<script type="text/html" id="customerCallbackLogsTemplate">
    <div class="returnWinList">
        {{if callbackLogs.length !=0}}
        {{each callbackLogs as log index}}
        <div class="returnWinItem">
            <div class="returnWinItem__txt">
                {{if log.content != "" && log.content != null}}
                {{log.content}}
                {{/if}}
                {{if log.callRecordId != "" && log.callRecordId != null}}
                <audio controls>
                    <source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path={{log.callRecordName}}">
                    Your browser does not support this audio format.
                </audio>
                {{/if}}
                {{if (log.content == "" || log.content == null)}}
                {{if (log.callRecordId == "" || log.callRecordId == null)}}
                [电话已拨，但未接通或被挂断]
                {{/if}}
                {{if (log.callRecordId != "" && log.callRecordId != null)}}
                [语音记录]
                {{/if}}
                {{/if}}
            </div>
            <div class="returnWinItem__name" style="width:222px;top:35px;margin-left:-60px;">{{log.managerName}}</div>
            <div class="returnWinItem__date" style="width:222px;top:35px;margin-left:-60px;">{{log.createTime |
                dateFormat:'yyyy-MM-dd hh:mm:ss'}}
            </div>
            {{/each}}
            {{else}}
            暂无回访记录
            {{/if}}
        </div>
    </div>
</script>

<script language="javascript" type="text/javascript">
    Date.prototype.pattern = function (fmt) {
        var o = {
            "M+": this.getMonth() + 1, //月份
            "d+": this.getDate(), //日
            "h+": this.getHours() % 12 == 0 ? 12 : this.getHours() % 12, //小时
            "H+": this.getHours(), //小时
            "m+": this.getMinutes(), //分
            "s+": this.getSeconds(), //秒
            "q+": Math.floor((this.getMonth() + 3) / 3), //季度
            "S": this.getMilliseconds() //毫秒
        };
        var week = {
            "0": "/u65e5",
            "1": "/u4e00",
            "2": "/u4e8c",
            "3": "/u4e09",
            "4": "/u56db",
            "5": "/u4e94",
            "6": "/u516d"
        };
        if (/(y+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
        }
        if (/(E+)/.test(fmt)) {
            fmt = fmt.replace(RegExp.$1, ((RegExp.$1.length > 1) ? (RegExp.$1.length > 2 ? "/u661f/u671f" : "/u5468") : "") + week[this.getDay() + ""]);
        }
        for (var k in o) {
            if (new RegExp("(" + k + ")").test(fmt)) {
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
            }
        }
        return fmt;
    };

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/customer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    function customerInfo(id, managerId) {
        setCookie("lastChoseCustomerId", id);
        window.open("/house365-hgs-web/platformmanagement/customerInfo?customerId=" + id + "&managerId=" + managerId, "_blank");
    }

    function deleteById(customerId) {
        House365Util.createModal("删除客户", "删除后将无法恢复，请确认是否继续？", function () {
            var url = "${ctx}/platformmanagement/deleteById/" + customerId;
            $.ajax({
                url: url,
                type: 'post',
                contentType: 'application/json',
                data: '',
                dataType: 'json',
                cache: false,
                success: function (result) {
                    if (result.status == 0) {
                        alert("删除成功");
                        window.location.reload();
                    }  else{
                        alert(result.errorMessage);
                    }
                }
            });
        });
    }

    function showCustomerCallbackLogs(_customerId, managerId) {
        setCookie("lastChoseCustomerId", _customerId);
        $.ajax({
            url: '${ctx}/customermanagement/getCustomerCallbackLogs',
            data: {
                "customerId": _customerId,
                "managerId": managerId
            },
            type: "GET",
            success: function (data) {

                var callContentHtml = template('customerCallbackLogsTemplate', {
                    ctx: "${ctx}",
                    callbackLogs: data
                });
                House365Util.createModal("回访记录", callContentHtml, function () {
                });
                $(".modal").css("width", "900px");
            }
        });
    }

    function showCustomerProjects(_customerId, managerId) {
        setCookie("lastChoseCustomerId", _customerId);
        $.ajax({
            url: '${ctx}/customermanagement/getCustomerProjects',
            data: {
                "customerId": _customerId,
                "managerId": managerId
            },
            type: "GET",
            success: function (data) {

                var callContentHtml = template('customerProjectsTemplate', {
                    ctx: "${ctx}",
                    customerProjects: data
                });
                House365Util.createModal("约看记录", callContentHtml, function () {
                });
                $(".modal").css("width", "900px");
            }
        });
    }

    function assignManager() {
        var customerIds = "",
            customerCont = 0;
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
                customerCont += 1;
            }
        }

        if (customerIds == '') {
            alert("请至少选择一个客户!");
            return false;
        }

        House365Util.createRemoteModal("客户转移", "/house365-hgs-web/customer/transferCreator?customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }
            debugger;
            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            if (customerIds == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            $.ajax({
                url: '/house365-hgs-web/customer/batchTransferCreator',
                data: {
                    "userIds": userIds,
                    "customerIds": customerIds
                },
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
        $(".modal").css("width", "560px");
    }

    /**
     * 客户标星
     * @param _this
     * @param userId 创建人id
     * @param star
     * @returns {boolean}
     */
    function toggleCollect(_this, _customerId,userId, star) {
        debugger;
        setCookie("lastChoseCustomerId", _customerId);
        var currentUserId = $("#currentUserId").val();
        if (star == 'on' && userId != currentUserId) {
            alert("其他人的星标客户不能取消哦");
            return false;
        }
        if (star == 'off' && userId != '' && userId != currentUserId) {
            alert("不能为其他客户添加星标哦");
            return false;
        }
        //收藏
        var flag = "off";
        if ($(_this).hasClass('on')) {
            $(_this).removeClass('on');
            $(_this).parents("tr").removeClass("table-star");
        } else {
            flag = "on";
            $(_this).addClass('on');
            $(_this).parents("tr").addClass("table-star");
        }

        $.ajax({
            url: "${ctx}/platformmanagement/starToggle",
            data: {flag: flag,customerId:_customerId},
            success: function (data) {
                window.location.reload();
            }
        });

    }

    //批量删除
    function batchDel() {
        var customerIdArr = [],
            mangerIdStateArr=[];
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIdArr.push(document.getElementsByName('memberCheck')[i].value);
                mangerIdStateArr.push(document.getElementsByClassName('mangerId_state')[i].textContent.replace(/[\r\n\s]/g, "").trim());
            }
        }
        if (customerIdArr.length<=0) {
            alert("请至少选择一个客户!");
            return false;
        }
        //不能删除非公海状态的用户
        for(j = 0,len=mangerIdStateArr.length; j < len; j++) {
            if (mangerIdStateArr[j]!='回公海') {
                alert("无法删除在跟进客户!");
                return false;
            }else {
                continue;
            }
        }

        House365Util.createModal("批量删除客户", "确认是否删除所选客户?", function () {
            var url = "${ctx}/platformmanagement/deleteIdList";
            $.ajax({
                url: url,
                type: 'post',
                contentType: 'application/json',
                data: JSON.stringify(customerIdArr),
                dataType: 'json',
                cache: false,
                success: function (result) {
                    if (result.status == 0) {
                        alert("删除成功");
                        window.location.reload();
                    }  else{
                        alert(result.errorMessage);
                    }
                }
            });
        });
    }


    //全选
    var checkNum = 0;
    function checkAll(btn) {
        if (btn.checked) {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                checkNum++;
                document.getElementsByName('memberCheck')[i].checked = "checked";
            }
        } else {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                checkNum++;
                document.getElementsByName('memberCheck')[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        } else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

</script>

<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>

<script type="text/javascript">

    function resetForm() {
        // 重置派工时间 全部 近7天 近30天 选中状态
        $("#bindTimeAll").css("color", "#30A3DE");
        $("#bindTimeRecentSeven").css("color", "#000000");
        $("#bindTimeRecentThirty").css("color", "#000000");
        // 重置添加时间 近7天 近30天 全部 选中状态
//        $("#createTimeRecentSeven").css("color", "#30A3DE");
//        $("#createTimeRecentThirty").css("color", "#000000");
//        $("#createTimeAll").css("color", "#000000");
        $("#createTimeRecentSeven").css("color", "#000000");
        $("#createTimeRecentThirty").css("color", "#000000");
        $("#createTimeAll").css("color", "#30A3DE");

        // 重置form
        $("#filterForm")[0].reset();
        $("#search_GTE_bindTimeStart").val('');
        $("#search_LTE_bindTimeEnd").val('');
        $("#search_GTE_singupTimeStart").val('');
        $("#search_LTE_singupTimeEnd").val('');
        $("#search_LIKE_name").val('');
        $("#search_LIKE_phone").val('');
        $("#search_LIKE_bakPhone1").val('');
        $("#search_LIKE_latestSource").val('');
        $("#search_LIKE_actSource").val('');
        $("#search_LIKE_managerName").val('');
        $("#search_GTE_createTimeStart").val('');
        $("#search_LTE_createTimeEnd").val('');
        $("#search_LIKE_sourceName").val('');
        $("#search_LIKE_createrName").val('');
        // 下拉框自定义时间
        $("#search_EQ_customTimeType").val('1');
        $("#search_GTE_customTimeStart").val('');
        $("#search_LTE_customTimeEnd").val('');

        $("#search_LIKE_callbackLog").val('');
        $("#search_LIKE_projectName").val('');

        // 重置营销活动下拉框
        $("#search_EQ_activeId").val("");
        $("#search_EQ_activeId").trigger('chosen:updated');
        // 重置回访状态下拉框
        $("#search_EQ_isBack").val("1");
        $("#search_EQ_isBack").trigger('chosen:updated');
        // 重置客户状态下拉框
        $("#search_EQ_platProjectStatus").val("");
        $("#search_EQ_platProjectStatus").trigger('chosen:updated');
        // 重置购房意向状态下拉框
        $("#search_EQ_buyIntention").val("all");
        $("#search_EQ_buyIntention").trigger('chosen:updated');
        // 重置是否星标下拉框
        $("#search_EQ_isPtStar").val("1");
        $("#search_EQ_isPtStar").trigger('chosen:updated');
        // 重置活动来源
        $("#search_EQ_actSource").val("");
        $("#search_EQ_actSource").trigger('chosen:updated');

        // 重置添加时间 近7天 开始时间结束时间
        createTimeClick('0');
    }

    //读取cookies
    function getCookie(name) {
        var arr, reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");

        if (arr = document.cookie.match(reg))

            return unescape(arr[2]);
        else
            return null;
    }

    //写cookies
    function setCookie(name, value) {
        $(".lastChoseCustomer").removeClass("lastChoseCustomer");
        $("#customerId_" + value).addClass("lastChoseCustomer");
        var Days = 30;
        var exp = new Date();
        exp.setTime(exp.getTime() + Days * 24 * 60 * 60 * 1000);
        document.cookie = name + "=" + escape(value) + ";expires=" + exp.toGMTString();
    }

    function createTimeClick(createTimeType) {
        var timeStart, timeEnd;
        var myDate = new Date();
        $("#timePeriod").val(createTimeType);

        switch (createTimeType) {
            case "2":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 7 + 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                $("#createTimeRecentSeven").css("color", "#30A3DE");
                $("#createTimeRecentThirty").css("color", "#000000");
                $("#createTimeAll").css("color", "#000000");
                break;
            case "1":
                timeEnd = myDate.pattern("yyyy-MM-dd");
                myDate.setDate(myDate.getDate() - 30 + 1);
                timeStart = myDate.pattern("yyyy-MM-dd");
                $("#createTimeRecentSeven").css("color", "#000000");
                $("#createTimeRecentThirty").css("color", "#30A3DE");
                $("#createTimeAll").css("color", "#000000");
                break;
            case "0":
                timeEnd = "";
                timeStart = "";
                $("#createTimeRecentSeven").css("color", "#000000");
                $("#createTimeRecentThirty").css("color", "#000000");
                $("#createTimeAll").css("color", "#30A3DE");
                break;
            default:
                break;
        }
        $("#search_GTE_createTimeStart").val(timeStart);
        $("#search_LTE_createTimeEnd").val(timeEnd);
    }

    var enterFlag = 0;
    $(document).keydown(function (event) {
        var style = document.getElementById("modal_dialog").style.display;
        if (style == 'block') {
            enterFlag = 1;
        } else {
            enterFlag = 0;
        }
        if (enterFlag == 0 && event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    var lastChoseCustomerId = getCookie("lastChoseCustomerId");

    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    });

    $(function () {
        $('.counter').counterUp({
            delay: 100,
            time: 2000
        });
        $("#customerId_" + lastChoseCustomerId).addClass("lastChoseCustomer");

        // 初始化添加时间
        if ($('#timePeriod').val() == '0') {
            createTimeClick('0');
        }

        // 派工时间
        var bindTimeStart = $("#search_GTE_bindTimeStart")
        var bindTimeEnd = $("#search_LTE_bindTimeEnd");
        bindTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: bindTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
            $("#bindTimeAll").css("color", "#000000");
            $("#bindTimeRecentSeven").css("color", "#000000");
            $("#bindTimeRecentThirty").css("color", "#000000");
        });
        bindTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: bindTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: bindTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_LTE_bindTimeEnd'
                    })
                }
            });
            $("#bindTimeAll").css("color", "#000000");
            $("#bindTimeRecentSeven").css("color", "#000000");
            $("#bindTimeRecentThirty").css("color", "#000000");
        });

        // 添加时间
        var createTimeStart = $("#search_GTE_createTimeStart")
        var createTimeEnd = $("#search_LTE_createTimeEnd");
        createTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: createTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
            $("#createTimeRecentSeven").css("color", "#000000");
            $("#createTimeRecentThirty").css("color", "#000000");
            $("#createTimeAll").css("color", "#000000");
            $("#timePeriod").val('3');
        });
        createTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: bindTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: createTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_LTE_createTimeEnd'
                    })
                }
            });
            $("#createTimeRecentSeven").css("color", "#000000");
            $("#createTimeRecentThirty").css("color", "#000000");
            $("#createTimeAll").css("color", "#000000");
            $("#timePeriod").val('3');
        });

        // 报名时间
        var singupTimeStart = $("#search_GTE_singupTimeStart");
        var singupTimeEnd = $("#search_LTE_singupTimeEnd");
        singupTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: singupTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
        });
        singupTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: singupTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: singupTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'singupTimeEnd'
                    })
                }
            });
        });

        // 自定义时间
        var customTimeStart = $("#search_GTE_customTimeStart");
        var customTimeEnd = $("#search_LTE_customTimeEnd");
        customTimeEnd.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                minDate: customTimeStart.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true
            });
        });
        customTimeStart.bind("click", function () {
            WdatePicker({
                startDate: "%y-{%M-1}-%d",
                maxDate: customTimeEnd.val(),
                dateFmt: "yyyy-MM-dd",
                autoPickDate: true,
                onpicked: function () {
                    WdatePicker({
                        startDate: "%y-{%M-1}-%d",
                        minDate: customTimeStart.val(),
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_LTE_customTimeEnd'
                    })
                }
            });
        });

        $('.baobei').each(function () { // Notice the .each() loop, discussed below
            $(this).qtip({
                content: {
                    text: $(this).next('div') // Use the "div" element next to this for the content
                },
                position: {
                    at: 'bottom center', // at the bottom right of...
                    target: $(this) // my target
                }
            });
        });

        $('.header').each(function () {
            $(this).nextUntil('tr.header').hide();
        });

        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });


    });

</script>
</body>
</html>
