<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<link rel="stylesheet" type="text/css" href="${static_common}/label/tag.css"/>
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "展开↓";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "收起↑";
    }

    .div-inline {
        display: inline-block;
    }

    .div-aaa {
        position: relative;
        overflow: auto;
        padding-left: 20px;
    }

    .div-aaa:before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        display: inline-block;
        background: #1890ff;
        width: 10px;
        height: 10px;
        border: 1px solid white;
        border-radius: 5px;
        z-index: 9;
    }

    .div-aaa:after {
        content: '';
        position: absolute;
        left: 4px;
        top: 0;
        display: inline-block;
        background: #1890ff;
        height: 100%;
        width: 2px;
        z-index: 8;
    }

    .div-aaa:last-child:after {
        display: none;
    }

    .td {
        text-align: center !important;
    }

    .tag-item {
        color: white;
    }

    .clearfix:before, .clearfix:after {
        content: "";
        display: block;
        clear: both;
    }

    .bt {
        padding: 5px 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
    }

    .color_999 {
        border: 1px solid #999;
        color: #999;
    }

    .color_d9534f {
        border: 1px solid #d9534f;
        color: #d9534f;
    }

    .color_f0ad4e {
        border: 1px solid #f0ad4e;
        color: #f0ad4e;
    }

    .color_5cb85c {
        border: 1px solid #5cb85c;
        color: #5cb85c;
    }

    .color_5bc0de {
        border: 1px solid #5bc0de;
        color: #5bc0de;
    }

    .color_0275d8 {
        border: 1px solid #0275d8;
        color: #0275d8;
    }

    .color_663399 {
        border: 1px solid #663399;
        color: #663399;
    }

    .temp {
        border: 1px solid #cccccc;
        width: 430px !important;
        height: 160px !important;
        position: relative;
        top: -26px;
        left: 81px;
    }

    .bat {
        padding: 5px 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
        margin: 0 5px;
    }

    .color_999 {
        border: 1px solid #999;
        color: #999;
    }

    .color_d9534f {
        border: 1px solid #d9534f;
        color: #d9534f;
    }

    .color_f0ad4e {
        border: 1px solid #f0ad4e;
        color: #f0ad4e;
    }

    .color_5cb85c {
        border: 1px solid #5cb85c;
        color: #5cb85c;
    }

    .color_5bc0de {
        border: 1px solid #5bc0de;
        color: #5bc0de;
    }

    .color_0275d8 {
        border: 1px solid #0275d8;
        color: #0275d8;
    }

    .color_663399 {
        border: 1px solid #663399;
        color: #663399;
    }

    .bt_last {
        background-color: #f0f0f0 !important;
        border: none !important;
        background-image: none !important;
    }

    .chosen-container {
        width: 96px !important;
    }
</style>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/customer<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li><a href="/house365-hgs-web/">首页</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    <a href="/house365-hgs-web/platformmanagement/myPlatformCustomer">平台客户</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    客户信息
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.name} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.name}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row-fluid">
        <c:if test="${displayBackToSeaDate == true}">
            <div class="span12">
                <span style="position: absolute;left: 40%;border-style: solid;padding: 20px;border-width: thin;border-color: #FFEED3;background-color: #FCF8E4;color: #896C3F;">
                    客户将在<c:out
                        value="${backToSeaDate}"/>返回公海，请及时跟进</span>
            </div>
        </c:if>
    </div>

    <div class="row${fluid}">
        <div class="span10 offset1">
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <input name="entity.id" type="hidden" value="${entity.id}"/>

                    <input name="entity.managerId" type="hidden" value="${entity.managerId}"/>
                    <input id="phone" name="phone" type="hidden" value="${entity.phone}"/>

                    <input name="entity.remark" id="entity_remark" type="hidden" value="${entity.remark}"/>

                    <div class="sectionTitle" style="height:30px;">
                        基本信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label"><span style="color:red;">*</span> 客户姓名:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='edit'}">
                                        <input type="text" id="entity.name"
                                               name="entity.name"
                                               value="${entity.name}"/>
                                        <span color="red"><form:errors path="customerVo.entity.name"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.name}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                                <sapn><a href="#" onclick="getCRM(${entity.id})">查看CRM视图</a></sapn>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">手机号码:</label>
                            <div class="controls">
                                <span class="inline">${entity.phone}&nbsp;</span>
                                <c:if test="${hasPhone == 1}">
                                    <span id="star" class="icon-phone-sign"
                                          onclick="callCustomer('${entity.phone}','${entity.markedLabelId}','${entity.managerId}','${entity.id}','${entity.buyIntention}','0','${entity.isPeer}','${entity.starCustomer}')"></span>
                                </c:if>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户类型:</label>
                            <div class="controls">
                                ${entity.createSource}
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">安家顾问:</label>
                            <div class="controls">
                                ${entity.managerName}
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">性别:</label>
                            <div class="controls">
                                <c:if test="${entity.sex eq '2' || entity.sex eq null}">未知</c:if>
                                <c:if test="${entity.sex eq '1'}">男</c:if>
                                <c:if test="${entity.sex eq '0'}">女</c:if>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">其他号码1:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='edit'}">
                                        <input type="text" id="entity_bakPhone1"
                                               name="entity.bakPhone1" maxlength="11"
                                               value="${entity.bakPhone1}"/>
                                        <span color="red"><form:errors path="customerVo.entity.bakPhone1"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.bakPhone1}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户状态:</label>
                            <div class="controls">
                                <span class="inline">${entity.platCustomerStatus}&nbsp;</span>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">购房意向:</label>
                            <div class="controls">
                                <c:if test="${entity.buyIntention eq '1'}">A</c:if>
                                <c:if test="${entity.buyIntention eq '2'}">B</c:if>
                                <c:if test="${entity.buyIntention eq '3'}">C</c:if>
                                <c:if test="${entity.buyIntention eq '4'}">D</c:if>
                            </div>
                        </div>
                    </div>

                    <%--<div class="row-fluid">--%>
                        <%--<div class="span5 control-group">--%>
                            <%--<label class="control-label">平台添加人:</label>--%>
                            <%--<div class="controls">--%>
                                <%--<span class="inline">${entity.creater}&nbsp;</span>--%>
                            <%--</div>--%>
                        <%--</div>--%>
                    <%--</div>--%>
                    <div class="sectionTitle" style="height:30px;">
                        回访记录&约看记录
                    </div>
                    <div>
                        <div class="div-inline" style="width: 45%;margin-left: 2%;vertical-align: top;">
                            <span>回访记录</span>
                            <div style="margin-top: 10px;border: 1px solid #ccc;padding: 10px;">
                                <c:forEach items="${callLogs}" var="call">
                                    <div class="row-fluid div-aaa">
                                        <div style="color: #ccc;margin-bottom: 10px;">
                                                ${call.managerName}
                                            <span style="float: right;color: #ccc">
                                                 <fmt:formatDate value='${call.createTime}'
                                                                 pattern='yyyy-MM-dd HH:mm:ss'/>
                                            </span>
                                        </div>

                                        <div style="margin-bottom: 10px;">
                                                ${call.content}
                                            <c:if test="${null ne call.callRecordName && '' ne call.callRecordName}">
                                                <span>
                                                    <audio controls>
                                                        <%--<source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path={{call.callRecordName}}">--%>
                                                        <source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path=${call.callRecordName}">
                                                         Your browser does not support this audio format.
                                                    </audio>
                                                </span>
                                            </c:if>
                                        </div>
                                    </div>
                                </c:forEach>
                                <c:if test="${0 eq fn:length(callLogs)}">
                                    <div style="margin-bottom: 10px;">
                                        暂无回访记录！
                                    </div>
                                </c:if>
                            </div>
                        </div>
                        <div class="div-inline" style="width: 45%;margin-left: 2%;">
                            <span>约看记录</span>
                            <div style="border: 1px solid #ccc;margin-top: 10px;">
                                <table class="table table-bordered"
                                       style="width: 90%;margin-left: 5%;margin-top: 10px;">
                                    <thead>
                                    <tr>
                                        <th class="td" width="100">约看项目</th>
                                        <th class="td" width="100">客户状态</th>
                                        <th class="td" width="100">约看时间</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <c:if test="${0 eq fn:length(customerProjects)}">
                                        <tr>
                                            <td colspan="3" class="td">
                                                暂无约看记录！
                                            </td>
                                        </tr>
                                    </c:if>
                                    <c:forEach items="${customerProjects}" var="cp">
                                        <tr>
                                            <td class="td">
                                                <a href="#">${cp.projectName}</a>
                                            </td>
                                            <td class="td">
                                                <c:if test="${not empty cp.status}">
                                                    <c:choose>
                                                        <c:when test="${cp.status eq '1'}">
                                                            <span class="inline">约看</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '2'}">
                                                            <span class="inline">到访</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '3'}">
                                                            <span class="inline">认筹</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '4'}">
                                                            <span class="inline">认购</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '5'}">
                                                            <span class="inline">签约</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '6'}">
                                                            <span class="inline">退房</span>
                                                        </c:when>
                                                    </c:choose>
                                                </c:if>
                                                <span style="color:red;">${cp.remark}</span>
                                            </td>
                                            <td class="td">
                                                <c:if test="${null ne cp.recordedTime}">
                                                    <f:formatDate value='${cp.recordedTime}'
                                                                  pattern='yyyy-MM-dd HH:mm:ss'/>
                                                </c:if>
                                            </td>
                                        </tr>
                                    </c:forEach>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;margin-top: 10px;">
                        客户情况与来源
                    </div>
                    <div class="row-fluid">
                        <table class="table table-bordered" style="width: 90%;margin-left: 5%;">
                            <thead>
                            <tr>
                                <th class="td" width="100">id</th>
                                <th class="td" width="100">来源类型</th>
                                <th class="td" width="100">最近来源</th>
                                <th class="td" width="100">活动名称</th>
                                <th class="td" width="100">CRM最近回访</th>
                                <th class="td" width="100">CRM回访结果</th>
                                <th class="td" width="100">添加时间</th>
                                <th class="td" width="100">平台添加人</th>
                            </tr>
                            </thead>
                            <tbody>
                            <c:forEach items="${oldList}" var="old">
                                <tr>
                                    <td class="td" width="100">${old.id}</td>
                                    <td class="td" width="100">${old.createSource}</td>
                                    <td class="td" width="100">${old.latestSource}</td>
                                    <td class="td" width="100">${old.actSource}</td>
                                    <td class="td" width="100">${old.crmLatestCall}</td>
                                    <td class="td" width="100">${old.crmLatestCallResult}</td>
                                    <td class="td">
                                        <c:if test="${null ne old.createTime}">
                                            <f:formatDate value='${old.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                                        </c:if>
                                    </td>

                                    <td class="td" width="100">
                                        <c:if test="${'平台导入' eq old.createSource}">${old.creater}</c:if>
                                        <c:if test="${'平台导入' ne old.createSource}"> </c:if>
                                    </td>
                                </tr>
                            </c:forEach>
                            </tbody>
                        </table>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        客户日志
                    </div>
                    <ul>
                        <c:forEach items="${logList}" var="log">
                            <li>
                                <c:out value="${log}"/>
                            </li>
                        </c:forEach>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
    var arr = new Array();
    var arr3 = new Array();
    var lids = '';
    $(function () {
        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });

        $('.header').click();
        <%--var labelFlag = ${labelFlag};--%>
        <%--if (labelFlag) {--%>
            <%--var lab = "${lids}";--%>
            <%--if (lab != undefined && lab != '') {--%>
                <%--lab = lab.substring(1, lab.length - 1);--%>
                <%--lab = lab.replace(/\s/g, "");--%>
                <%--arr = lab.split(",");--%>
            <%--}--%>
        <%--} else {--%>
            <%--console.log(lids);--%>
        <%--}--%>
        <%--var obj = $(".bt");--%>
        <%--for(var i=0;i< obj.length;i++){--%>
            <%--for(var j=0;j<arr.length;j++){--%>
                <%--if(obj[i].value == arr[j]){--%>
                    <%--console.log($(".bt")[i].value);--%>
                    <%--$(".bt")[i].click();--%>
                <%--}--%>
            <%--}--%>

        <%--}--%>
    });




    function commitForm() {
        var phone1 = $("#entity_bakPhone1").val();
        if (phone1 != "" && !checkMobile(phone1)) {
            House365Util.createModal("提示", "其他号码1格式不正确", function () {
                $("#entity_bakPhone1").focus();
            });
            return false;
        }

        var buyIntention = $("#buyIntention").val();
        if (buyIntention == "" || buyIntention == null) {
            alert("购房意向未填写");
            return false;
        }

        if (buyIntention == 5) {
            House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
                $("#input_form").submit();
            });
        } else {
            $("#input_form").submit();
        }
    }

    function checkMobile(val) {
        var pattern = /(^(([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)|(^0{0,1}1[3|4|5|6|7|8|9][0-9]{9}$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }
    }



    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/customer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    var curnet = "${sessionUser.cornet}";

    function setCallbackContent(template) {
        var content = $(template).text();
        var obj = document.getElementById("callContent");
        obj.innerHTML = content;
//        $("#callContent").=content;
    }



    $(document).on('click', '.collect', function () {
        var customerId = ${entity.id};
        $.ajax({
            url: '${ctx}/customermanagement/judgeStar/' + customerId,
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    var img_src = $('#starImage').attr("src");
                    if (img_src === '${ctx}/resources/img/collect_no.png') {
                        $('#starImage').attr("src", "${ctx}/resources/img/collect_yes.png")
                    } else {
                        $('#starImage').attr("src", "${ctx}/resources/img/collect_no.png")
                    }
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    });

</script>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>
<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>

</html>
