<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/notice<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/notice">公告表列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="portlet-header">
                <div class="operation-btn pull-right">
                    <c:choose>
                        <c:when test="${null != entity.red}">
                            <input type="hidden" name="entity.red" id="entity_red" value="${entity.red}">
                        </c:when>
                        <c:otherwise>
                            <input type="hidden" name="entity.red" id="entity_red" value="false">
                        </c:otherwise>
                    </c:choose>
                    <c:choose>
                        <c:when test="${null != entity.top}">
                            <input type="hidden" name="entity.top" id="entity_top" value="${entity.top}">
                        </c:when>
                        <c:otherwise>
                            <input type="hidden" name="entity.top" id="entity_top" value="false">
                        </c:otherwise>
                    </c:choose>
                    <input type="hidden" name="entity.createUserid" value="${entity.createUserid}">
                    <input type="hidden" name="entity.createIp" value="${entity.createIp}">
                    <input type="hidden" name="entity.createUsername" value="${entity.createUsername}">
                    <input type="hidden" name="entity.city" value="${entity.city}">
                    <input type="hidden" name="entity.cityName" value="${entity.cityName}">
                    <input type="hidden" id="entity.createTimeStr" name="entity.createTimeStr"
                           value="<fmt:formatDate value='${entity.createTime}' pattern='yyyy-MM-dd HH:mm:ss' />"/>
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <button class="btn blue" type="submit"><i
                                    class="icon-save"></i>&nbsp;保存
                            </button>
                            <a href="${ctx}/notice/${entity.id}" class="btn gray"><i
                                    class="icon-mail-reply"></i>&nbsp;取消</a>
                        </c:when>
                        <c:when test="${action=='create'}">
                            <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                            <a href="${ctx}/notice" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:when>
                        <c:otherwise>
                            <a href="${ctx}/notice/${entity.id}?action=edit" class="btn blue"><i
                                    class="icon-edit"></i>&nbsp;编辑</a>
                            <a href="${ctx}/notice" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </c:otherwise>
                    </c:choose>
                </div>
            </div>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>新增</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <div class="row-fluid">
                        <div class="span10 control-group">
                            <label class="control-label">标题:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.title" maxlength="20"
                                               name="entity.title" class="span12"
                                               value="${entity.title}"/>
                                        <font color="red"><form:errors path="noticeVo.entity.title"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.title}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span3 control-group">
                            <label class="control-label">置顶:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <c:if test="${entity.top}">
                                            <input type="checkbox" data-size="mini" data-on-text="开启"
                                                   data-off-text="关闭" id="top"
                                                   value="${entity.top}"
                                                   checked="checked">
                                        </c:if>
                                        <c:if test="${!entity.top}">
                                            <input type="checkbox" data-size="mini" data-on-text="开启" data-off-text="关闭"
                                                   id="top" value="${entity.top}">
                                        </c:if>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">

                                        <c:if test="${entity.top}">
                                            是
                                        </c:if>
                                        <c:if test="${!entity.top}">
                                            否
                                        </c:if>

                                            &nbsp;
                                        </span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span3 control-group">
                            <label class="control-label">标红:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <c:if test="${entity.red}">
                                            <input type="checkbox" data-size="mini" data-on-text="开启" data-off-text="关闭"
                                                   id="red" value="${entity.red}"
                                                   checked="checked">
                                        </c:if>
                                        <c:if test="${!entity.red}">
                                            <input type="checkbox" data-size="mini" data-on-text="开启" data-off-text="关闭"
                                                   id="red" value="${entity.red}">
                                        </c:if>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">
                                        <c:if test="${entity.red}">
                                            是
                                        </c:if>
                                        <c:if test="${!entity.red}">
                                            否
                                        </c:if>
                                            &nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span10 control-group">
                            <label class="control-label">内容:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
										<textarea class="description required"
                                                  style="margin: 0px; height: 126px; width: 616px;"
                                                  id="entity.content"
                                                  name="entity.content"
                                                  onblur="removeError()">${entity.content}</textarea>
                                    </c:when>
                                    <c:otherwise>
                                        <span style="line-height: 40px;">${entity.content}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

</form>
<script src="http://cdn.bootcss.com/jquery-validate/1.14.0/jquery.validate.min.js"></script>
<script type="text/javascript" src="${static_common}/ckeditor/ckeditor.js"></script>

<script language="JavaScript">
    $(function () {
        $("#top").bootstrapSwitch();
        $("#red").bootstrapSwitch();

        $("#top").on('switchChange.bootstrapSwitch', function (event, state) {
//            console.log(this); // DOM element
//            console.log(event); // jQuery event
//            console.log(state); // true | false
            $("#entity_top").val(state);
        });
        $("#red").on('switchChange.bootstrapSwitch', function (event, state) {
//            console.log(this); // DOM element
//            console.log(event); // jQuery event
//            console.log(state); // true | false
            $("#entity_red").val(state);
        });

        CKEDITOR.replaceAll(
                function (textarea, config) {
                    config.filebrowserUploadUrl = '${ctx}/CKEdit/picUpload?Type=File';
                    config.filebrowserImageUploadUrl = '${ctx}/CKEdit/picUpload?Type=Image';
                    config.filebrowserFlashUploadUrl = '${ctx}/CKEdit/picUpload?Type=Flash';
                });

        function removeError() {
            $(".error").siblings("label").hide();
        }
    });
</script>

</body>

</html>
