<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
</head>
<body>
<c:if test="${not empty attachmentList or editAble}">
<div class="row${fluid}">
    <div class="span12 control-group">
        </c:if>
        <c:if test="${editAble and fn:length(attachmentList) lt maxSize}">
            <div class="sub_message" id="${bizType}_upload_form_msg"></div>
            <form id="${bizType}_upload_form"
                  name="${bizType}_upload_form" enctype="multipart/form-data"
                  action="${ctx}/image/addSection?resourceType=${resourceType}&resourceId=${resourceId}&bizType=${bizType}"
                  method="post" class="valid form-horizontal">
                <div class="row${fluid}">
                    <div class="span12">
                        <img width="133px" class="bigPic" src="/house365-hgs-web/resources/img/default.jpg"/>
                        <label for="${bizType}_file" class="sm_label">上传文件</label>
                        <input type="file" id="${bizType}_file"
                               name="${bizType}_file" value="" class=" imageValid"
                               placeholder="请选择上传图片" title="请选择上传图片"
                               accept="image/gif,image/jpeg,image/jpg,image/png,image/svg"/>
                        <input type="hidden" id="${bizType}_t" name="${bizType}_t" value="">
                    </div>
                </div>
            </form>
        </c:if>
        <c:choose>
            <c:when test="${empty attachmentList}"></c:when>
            <c:otherwise>
                <div>
                    <div class="row${fluid}">
                        <c:forEach items="${attachmentList}" var="image" varStatus="i">
                            <div class="sm_img">
                                <c:choose>
                                    <c:when test="${editAble }">
                                        <i class="img-remove icon-remove"
                                           onclick="deleteById('${bizType }', '${image.id}')"></i>
                                    </c:when>
                                    <c:otherwise>
                                        <i>&nbsp;</i>
                                    </c:otherwise>
                                </c:choose>
                                <input type="hidden" id="${resourceType}_picture_${i.index}"
                                       name="${resourceType}_picture_${i.index}" value="${image.id}"/>
                                <img class="img-show" src="${image.x2RemotePath}">
                                <c:if test="${resourceType =='hgs_user_fullImg' or resourceType =='hgs_user_headImg' }">
                                    <label id="edit_picture" class="sm_label"
                                           onclick="cuttingPicture('${image.x2RemotePath}','${image.id}','${resourceId}','${resourceType}','${bizType}')">编辑图片</label>
                                </c:if>
                            </div>
                        </c:forEach>
                    </div>
                </div>
            </c:otherwise>
        </c:choose>
        <c:if test="${not empty attachmentList or editAble}">
    </div>
</div>
</c:if>
<script type="text/javascript" language="javascript">
    $(document).ready(function () {
        $("#${bizType}_file").on("change", function () {
            var $uploadForm = $("#${bizType}_upload_form");
            $("#${bizType}_t").val(new Date());
            var validValue = $uploadForm.valid();
            if (validValue) {
                $.ajaxFileUpload({
                    // 文件上传服务器地址
                    url: $uploadForm.attr("action"),
                    // 文件上传服务器地址
                    fileElementId: "${bizType}_file",
                    // 表单数据
                    data: $uploadForm.serialize(),
                    // 成功回调
                    success: function (data, status) {
                        window.location.reload();
                    },
                    error: function (data, status, e) {
                        // 失败后操作
                        alert("上传失败，请联系管理员！");
                    },
                    complete: function (request) {
                        // 列表页
                        var $listContainer = $("#${bizType}_list_container");

                        // 刷新列表页
                        House365Util.ajaxTurn2Page($listContainer, $listContainer.attr("base-url"), 1);
                        <%--callback(${bizType});--%>
                        if (-1 != request.responseText.indexOf("MAX_SIZE")) {
                            alert("文件过大，请重新选择文件！");
                        }
                        window.location.reload();
                    }
                });
            }
        });
    });
    function deleteById(bizType, id) {
        House365Util.createModal('删除附件', '确定要删除此附件？', function () {
            $.ajax({ //提交表单
                url: ctx + '/attachment/delete/' + id, //获取提交到的页面
                type: "DELETE",
                success: function (data) {
                    if ("10000" == data) {
                        House365Util.ajaxTurn2Page($("#" + bizType
                            + "_list_container"), $(
                            "#" + bizType + "_list_container")
                            .attr("base-url"), 1);
                        window.location.reload();
                    } else {
                        House365Util.showAlertMessage($("#message"), "删除失败！", "error");
                    }
                }

            });
        });
    }

    function cuttingPicture(param, imageId, resourceId, resourceType, bizType) {
        var temp = document.createElement("form");
        temp.action = '${ctx}/role/cuttingPicture';
        temp.method = "post";
        datas = {
            resourceId: resourceId,
            resourceType: resourceType,
            bizType: bizType,
            pictureUrl: param,
            imageId: imageId,
        };

        for (var data in datas) {
            var opt = document.createElement("textarea");
            opt.name = data;
            opt.value = datas[data];
            temp.appendChild(opt);
        }
        document.body.appendChild(temp);
        temp.submit();
        return temp;
    }
</script>
<style type="text/css">
    .img-remove {
        position: relative;
        left: 106px;
        top: -6px;
        cursor: pointer;
    }

    .img-show {
        top: 20px;
    }

    /*BSM ADD*/
    .info .bd ul {
        margin: 0;
    }

    .form-horizontal .control-label {
        width: 120px;
    }

    .img-remove {
        background: #ccc;
        border-radius: 10px;
        text-align: center;
        line-height: 20px;
        width: 20px;
        height: 20px;
        left: 155px;
    }

    .img-show {
        margin-top: -20px;
    }

    .sm_img {
        position: relative;
        width: 166px;
        margin-left: 18px;
        margin-bottom: 20px;
        display: inline-block;
    }

    .sm_img .img-show {
        width: 160px;
        height: 120px;
        border: 1px solid #ccc;
        padding: 2px;
        border-radius: 5px;
        -webkit-border-radius: 5px;
        -moz-border-radius: 5px;
        -ms-border-radius: 5px;
        -o-border-radius: 5px;
    }

    .span12 .control-label {
        padding-top: 5px;
    }

    .span12 .imageValid {
        display: none !important;
    }

    .sm_label {
        -moz-user-select: none;
        background-image: none;
        border: 1px solid transparent;
        border-radius: 4px;
        cursor: pointer;
        display: inline-block;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857;
        margin-bottom: 0;
        padding: 6px 12px;
        text-align: center;
        vertical-align: middle;
        white-space: nowrap;
        background-color: #337ab7;
        border-color: #2e6da4;
        color: #fff;
        margin-left: 32px;
    }


</style>
</body>
</html>
