<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>我的客户</title>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        display: inline-block;
    }

    .header.expand .sign:after {
        /*content: "-";*/
    }
</style>
<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li>
                <a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                <a href="/house365-hgs-web/customer/myRecordedCustomer?projectId=${param['projectId']}">约看客户列表</a>
            </li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <p>约看客户列表：【${projectName}】</p>
        <ul class="breadcrumb">
            <li class="active">共${totalCount}条数据，今日新增${newCount}条</li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm"
                  action="${ctx}/customer/myRecordedCustomer?projectId=${projectId}" method="get">
                <input type="hidden" name="projectId" value="${projectId}">
                <input type="text" name="search_LIKE_name" value="${param['search_LIKE_name']}"
                       class="m-wrap small span2" placeholder="客户姓名/手机号码">
                <%--<input type="text" name="search_LIKE_houseName" value="${param['search_LIKE_houseName']}"--%>
                <%--class="m-wrap small span2" placeholder="楼盘名称">--%>
                <input type="text" name="search_LIKE_managerName" value="${param['search_LIKE_managerName']}"
                       class="m-wrap small span2" placeholder="置业顾问">
                <input type="text" name="search_GTE_createTimeStart" id="search_GTE_createTimeStart"
                       value="${param['search_GTE_createTimeStart']}"
                       class="m-wrap small span2" placeholder="添加时间-开始">至
                <input type="text" name="search_LTE_createTimeEnd" id="search_LTE_createTimeEnd"
                       value="${param['search_LTE_createTimeEnd']}"
                       class="m-wrap small span2" placeholder="添加时间-截止">
                <select name="search_EQ_recordedStatus" id="search_EQ_recordedStatus">
                    <option>案场报备状态</option>
                    <option value="" <c:if test="${'' eq param['search_EQ_recordedStatus']}">selected="selected"</c:if>>
                        待定
                    </option>
                    <option value="0"
                            <c:if test="${'0' eq param['search_EQ_recordedStatus']}">selected="selected"</c:if>>
                        无效
                    </option>
                    <option value="1"
                            <c:if test="${'1' eq param['search_EQ_recordedStatus']}">selected="selected"</c:if>>
                        有效
                    </option>
                </select>
                <select name="search_EQ_projectStatus" id="search_EQ_projectStatus">
                    <option value="">客户状态</option>
                    <option value="1"
                            <c:if test="${'1' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        约看
                    </option>
                    <option value="2"
                            <c:if test="${'2' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        到访
                    </option>
                    <option value="3"
                            <c:if test="${'3' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        认筹
                    </option>
                    <option value="4"
                            <c:if test="${'4' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        认购
                    </option>
                    <option value="5"
                            <c:if test="${'5' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        签约
                    </option>
                    <option value="6"
                            <c:if test="${'6' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        退房
                    </option>
                </select>
                <select name="search_EQ_loanStatus" id="search_EQ_loanStatus">
                    <option value="">贷款状态</option>
                    <option value="0" <c:if test="${'0' eq param['search_EQ_loanStatus']}">selected="selected"</c:if>>
                        未办理
                    </option>
                    <option value="1" <c:if test="${'1' eq param['search_EQ_loanStatus']}">selected="selected"</c:if>>
                        申请中
                    </option>
                    <option value="2" <c:if test="${'2' eq param['search_EQ_loanStatus']}">selected="selected"</c:if>>
                        已下款
                    </option>
                    <option value="3" <c:if test="${'3' eq param['search_EQ_loanStatus']}">selected="selected"</c:if>>
                        被拒绝
                    </option>
                    <option value="4" <c:if test="${'4' eq param['search_EQ_loanStatus']}">selected="selected"</c:if>>
                        全款支付
                    </option>
                </select>

                <span style="margin-left: 10px;">
                    <button type="button" class="btn btn-primary btn-sm" onclick="projectTurn('', ${projectId})">项目转移</button>
                </span>

                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th class="span1" width="50" style="text-align:center">
                <input id="memberCheckAll" type="checkbox" onclick="checkAll(this)"/>
            </th>
            <%--序号、姓名、购房意向、客户类型、置业顾问、活动来源、案场报备、重客、约看时间、添加时间、操作--%>
            <th width="100">序号</th>
            <th width="100">姓名</th>
            <th width="100">电话</th>
            <th width="100">购房意向</th>
            <th width="100">客户类型</th>
            <th width="100">置业顾问</th>
            <th width="100">活动来源</th>
            <%--<th width="100">约看楼盘</th>--%>
            <th width="100">案场报备</th>
            <th width="100">客户状态</th>
            <th width="100">重客</th>

            <%--<th width="100">贷款状态</th>--%>
            <th width="100">约看时间</th>
            <th width="100">添加日期</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${customers}" var="customer">
            <tr class="header expand">
                <td class="span1" style="text-align:center">
                    <input type="checkbox" name="memberCheck" value="${customer.id}" repeat="${customer.isRepeat}"
                           majorId="${customer.majorId}" onclick="checkMember(this)"/>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.id && '' ne customer.id}">
                        <c:out value="${customer.id}"/>
                    </c:if>
                    <c:if test="${null eq customer.id || '' eq customer.id}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.name && '' ne customer.name}">
                        <c:out value="${customer.name}"/>
                    </c:if>
                    <c:if test="${null eq customer.name || '' eq customer.name}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.phone && '' ne customer.phone}">
                        <c:out value="${customer.phone}"/>
                    </c:if>
                    <c:if test="${null eq customer.phone || '' eq customer.phone}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.buyIntention && '' ne customer.buyIntention}">
                        <c:choose>
                            <c:when test="${customer.buyIntention eq '1'}">
                                <span class="inline">A</span>
                            </c:when>
                            <c:when test="${customer.buyIntention eq '2'}">
                                <span class="inline">B</span>
                            </c:when>
                            <c:when test="${customer.buyIntention eq '3'}">
                                <span class="inline">C</span>
                            </c:when>
                            <c:when test="${customer.buyIntention eq '4'}">
                                <span class="inline">D</span>
                            </c:when>
                            <c:when test="${customer.buyIntention eq '5'}">
                                <span class="inline">E</span>
                            </c:when>
                        </c:choose>
                    </c:if>
                    <c:if test="${null eq customer.buyIntention || '' eq customer.buyIntention}">
                        &nbsp;待定
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <span class="inline">${customer.createSource}</span>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.managerName && '' ne customer.managerName}">
                        <c:out value="${customer.managerName}"/>
                    </c:if>
                    <c:if test="${null eq customer.managerName || '' eq customer.managerName}">
                        &nbsp;
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${null ne customer.actSource && '' ne customer.actSource}">
                        <c:out value="${customer.actSource}"/>
                    </c:if>
                    <c:if test="${null eq customer.actSource || '' eq customer.actSource}">
                        &nbsp;
                    </c:if>
                </td>

                <td nowrap="nowrap">
                    <c:if test="${not empty customer.cps}">

                        <c:if test="${empty customer.cps[0].recordedStatus}">
                            待定
                        </c:if>
                        <c:if test="${not empty customer.cps[0].recordedStatus}">
                            <c:choose>
                                <c:when test="${customer.cps[0].recordedStatus eq '1'}">
                                    <span class="inline">有效</span>
                                </c:when>
                                <c:when test="${customer.cps[0].recordedStatus eq '0'}">
                                    <span class="inline">无效</span>
                                </c:when>
                            </c:choose>
                        </c:if>
                    </c:if>
                    <c:if test="${empty customer.cps}">
                    </c:if>
                </td>
                <td nowrap="nowrap">
                    <c:if test="${not empty customer.cps}">
                        <c:choose>
                            <c:when test="${customer.cps[0].status eq '1'}">
                                <span class="inline">约看</span>
                            </c:when>
                            <c:when test="${customer.cps[0].status eq '2'}">
                                <span class="inline">到访</span>
                            </c:when>
                            <c:when test="${customer.cps[0].status eq '3'}">
                                <span class="inline">认筹</span>
                            </c:when>
                            <c:when test="${customer.cps[0].status eq '4'}">
                                <span class="inline">认购</span>
                            </c:when>
                            <c:when test="${customer.cps[0].status eq '5'}">
                                <span class="inline">签约</span>
                            </c:when>
                            <c:when test="${customer.cps[0].status eq '6'}">
                                <span class="inline">退房</span>
                            </c:when>
                        </c:choose>
                    </c:if>
                    <c:if test="${empty customer.cps}">
                    </c:if>
                </td>

                <td nowrap="nowrap">
                    <c:if test="${customer.isRepeat eq 0}">
                    </c:if>
                    <c:if test="${customer.isRepeat  eq 1}">
                        主客id：${customer.majorId}
                        <%--重客--%>
                    </c:if>
                </td>

                <td nowrap="nowrap">
                    <c:if test="${not empty customer.cps}">
                        <f:formatDate value='${customer.cps[0].createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${empty customer.cps}">
                    </c:if>
                </td>

                <td nowrap="nowrap">
                    <c:if test="${null ne customer.createTime && '' ne customer.createTime}">
                        <f:formatDate value='${customer.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                    </c:if>
                    <c:if test="${null eq customer.createTime || '' eq customer.createTime}">
                        &nbsp;
                    </c:if>
                </td>

                <td nowrap="nowrap">
                    <button type="button" class="btn btn-default"
                            onclick="cpInfo(${customer.cps[0].id},${customer.id},${customer.isRepeat})">维护
                    </button>
                    <button type="button" class="btn btn-default"
                            onclick="customerInfo(${customer.id})">详情
                    </button>
                    <c:if test="${customer.isRepeat  eq 1}">
                        <button type="button" class="btn btn-default" onclick="setMajorCustomer(${customer.cps[0].id})">
                            设主客
                        </button>
                    </c:if>
                </td>
            </tr>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>

<script type="text/javascript">
    var repeat = 0;
    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    var newTurnCustomerId = "";
    function projectTurn(customerId, oldProjectId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         */

        if (customerId == "") {
            for (var i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    customerId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

//            var str = "";
            if (customerId != "") {
                customerId = customerId.substring(0, customerId.length - 1);
            }
        }
        if (customerId == "") {
            alert("请至少选择一个客户!");
            return false;
        }
        if (repeat > 0) {
            alert("不支持转移重客,请重新选择");
            return false;
        }
        newTurnCustomerId = customerId;
        House365Util.createRemoteModal("项目转移", "${ctx}/customer/turnProject?customerId=" + newTurnCustomerId + "&oldProjectId=" + oldProjectId, null, function () {
            var projectId = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("约看项目不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                projectId = projectId + $(this).val() + ",";
            });

            if (projectId == '') {
                alert("至少要选择一个项目!");
                return false;
            }
            $.ajax({
                url: '${ctx}/customer/bindTurnProject',
                data: {"projectId": projectId, "customerId": newTurnCustomerId, "oldProjectId": oldProjectId},
                type: "GET",
                success: function (data) {
                    if (data == '1') {
                        alert("转移成功");
                        window.location.reload();
                    } else {
                        alert("所选项目已有客户" + data + ",请重新选择");
                    }
                }
            });
            return true;
        });

    };

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (var i = 0; i < document.getElementsByName("memberCheck").length; i++) {
                document.getElementsByName("memberCheck")[i].checked = "checked";
                var sob = document.getElementsByName("memberCheck")[i].attributes.repeat.value;
                if (sob == 1) {
                    repeat++;
                }
            }
        }
        else {
            for (var i = 0; i < document.getElementsByName("memberCheck").length; i++) {
                document.getElementsByName("memberCheck")[i].checked = "";
                repeat--;
            }

        }
    }

    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            var sob = btn.attributes.repeat.value;
            if (sob == 1) {
                repeat++;
            }
            for (var i = 0; i < document.getElementsByName("memberCheck").length; i++) {
                if (document.getElementsByName("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
            var sob = btn.attributes.repeat.value;
            if (sob == 1) {
                repeat--;
            }
        }
    }

    $(function () {
        var startTime = $("#search_GTE_createTimeStart")
        var endTime = $("#search_LTE_createTimeEnd");
        endTime.bind("click", function () {
            WdatePicker({doubleCalendar: true, startDate: "%y-{%M-1}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: true});
        });
        startTime.bind("click", function () {
            WdatePicker({
                doubleCalendar: true, startDate: "%y-{%M-1}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: true,
                onpicked: function () {
//                    $("#search_LTE_createTimeEnd").click();
                    WdatePicker({
                        doubleCalendar: true,
                        startDate: "%y-{%M-1}-%d",
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_LTE_createTimeEnd'
                    })
                }
            });
        });

    });

    function customerInfo(id) {
        $.ajax({
            url: '${ctx}/customer/judgePrivate/' + id,
            type: "POST",
            success: function (data) {
                if (data.status == 0) {
                    window.open("${ctx}/customer/customerInfo?action=edit&customerId=" + id + "&projectId=" +${param['projectId']}, '_blank');
                } else {
                    window.open("/house365-hgs-web/customer/seaCustomerInfo?action=edit&customerId=" + id, "_blank");
//                    alert(data.errorMessage);
                }
            }
        });
    }

    function cpInfo(id, customerId, isRepeat) {
        if (isRepeat == 1) {
            alert("该客户为重客，无法维护");
            return;
        }
        $.ajax({
            url: '${ctx}/customer/judgePrivate/' + customerId,
            type: "POST",
            success: function (data) {
                if (data.status == 0) {
                    window.open("${ctx}/customer/updateProjectInfo/" + id, '_blank');
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    }

    var setMajorCustomer = function (id) {
        House365Util.createModal("设置主客", "修改主客将把原主客状态重置为约看状态，是否确认操作？", function () {
            console.log(id);
            $.ajax({
                url: '${ctx}/customer/setMajorCustomer/' + id,
                type: "POST",
                success: function (data) {
                    if (data.status == 0) {
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.errorMessage);
                    }
                }
            });
        });
    };

</script>
</body>
</html>
