<%@ page language="java" pageEncoding="UTF-8" %>
<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<html>
<head>
    <title>指派楼盘</title>
</head>
<body>

<div style="width: 600px;height: 300px;">
    <div style="width: 500px;">
        <input type="text" id="chooseRelBuilding" class="span4"/>

    </div>
    <br>
    <div style="width: 500px;" id="buildings">
        <div style="width: 400px;clear: both;"></div>
        <c:set var="departmentNameList" value="${fn:split(departmentNames, ',')}"/>
        <c:set var="departmentIdList" value="${fn:split(departmentIds, ',')}"/>
        <c:forEach items="${departmentNameList}" var="departmentName" varStatus="nameCount">
            <c:if test="${departmentName ne ''}">
                <div style="margin-top: 5px;padding:10px;border: 1px dotted #bc06c5;">
                    <c:forEach items="${departmentIdList}" var="departmentId" varStatus="idCount">
                        <c:if test="${nameCount.index == idCount.index}">
                            <input type="hidden" value="${departmentId}" name="buildId"/>
                        </c:if>
                    </c:forEach>
                    <input type="hidden" value="${departmentName}" name="buildName">
                    <i class="img-remove icon-remove" onclick="delBuilding(this)"></i>${departmentName}
                </div>
            </c:if>
        </c:forEach>
    </div>
</div>

</body>
<script type="text/javascript">
    var buildingId = new Array();
    var buildingName = new Array();
    var maxCount = ${maxCount};

    function delBuilding(div) {
        $(div).parent('div').remove();
    }

    $(document).ready(function () {

        $("#chooseRelBuilding").select2({
            placeholder: "请选择关联楼盘",
            // 输入几个字符开始联想
            minimumInputLength: 1,
            // 最大返回记录数
            minimumResultsForSearch: 10,
            maximumSelectionLength: 1,
            minimumSelectionLength: 1,
            containerCssClass: "chosen, chosen-with-diselect",
            query: function (query) {
                $.ajax({
                    timeout: 1000,
                    url: "${ctx}/remoteJson/getJson",
                    data: {
                        url: "http://newapi.house365.com/projects/name",
                        city: "${city}",
                        limit: 10,
                        name: query.term,
                        like: 1
                    },
                    type: "GET",
                    dataType: "json",
                    success: function (data, status) {
                        var pageData = {
                            results: []
                        };
                        $.each(data.data.list, function (i, item) {
                            pageData.results.push({
                                id: item.itemname + "@#" + item.listid + "@#" + item.channel_name,
                                text: item.itemname + "(" + item.channel_name + ")"
                            });
                        });
                        query.callback(pageData);
                    },
                    error: function () {
                        var pageData = {
                            results: []
                        };
                        query.callback(pageData);
                    }
                });
            }
        });

        $("#chooseRelBuilding").change(function () {
            var chooseHouse = $(this).val();
            if (chooseHouse) {
                var idstr = "";
                var namestr = "";
                var houses = chooseHouse.split("@#");
                if ($("[name='buildId']").length > (maxCount - 1)) {
                    alert("最多可选" + maxCount + "个楼盘");
                    return;
                }
                buildingId.push(houses[1]);
                buildingName.push(houses[0] + "(" + houses[2] + ")");
//                buildingId.forEach(function (id) {
//                    idstr = idstr + id + ",";
//                });
//                buildingName.forEach(function (na) {
//                    namestr = namestr + na + ",";
//                });
                $("#buildingName").val(namestr);
                $("#buildingId").val(idstr);
                $("#buildings").append("<div style='margin-top: 5px;padding:10px;border: 1px dotted #bc06c5;'><input " +
                    "type='hidden' value='" + houses[1] + "' name='buildId'><input type='hidden' value='" + houses[0] +
                    "(" + houses[2] + ")" + "' name='buildName'><i class=\"img-remove icon-remove\" " +
                    "onclick=\"delBuilding(this)\"></i>" + houses[0] + "(" + houses[2] + ")" + "</div>");
            }
        });


    });
</script>
</html>
