<%@ page contentType="text/html;charset=UTF-8" %>
<%@include file="/WEB-INF/common/layouts/common.jsp" %>

<!-- HEADER START -->
<div class="navbar navbar-inverse navbar-fixed-top" style="z-index: 999999">

    <div class="navbar-inner">
        <div class="container${fluid}">
            <div class="row${fluid}">
                <div class="pull-left span9">
                    <a href="${ctx}/" class="brand">
                        <i class="icon-flag" style="vertical-align: middle;"></i> HOUSE365
                    </a>
                    <ul class="nav nav-pills">
                        <shiro:hasPermission name="GL or SJGH or TJFX or GGGL">
                            <li class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#" id="index_menu">概览 <b
                                        class="caret"></b></a>
                                <ul class="dropdown-menu" aria-labelledby="index_menu">
                                    <shiro:hasPermission name="GL">
                                        <li><a href="${ctx}/index/">概览</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="SJGH">
                                        <li><a href="${ctx}/customer/">数据公海</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="QKGH">
                                        <li><a href="${ctx}/rushcustomer/">抢客数据公海</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="TJFX">
                                        <li class="dropdown-submenu">
                                            <a tabindex="-1" href="#">统计与分析</a>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a tabindex="-1" href="${ctx}/statistic/statusSourceStatistic/">状态来源分析</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1" href="${ctx}/statistic/projectSource/">项目来源分析</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1" href="${ctx}/statistic/customerStatistic/">客户分析</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1" href="${ctx}/statistic/customerTransStatistic/">客户转化分析</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/statistic/projectTransform/">项目转化分析</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1" href="${ctx}/statistic/localReportStatistic/">项目日报分析</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1" href="${ctx}/statistic/reportMarketingStatistic/">直销日报分析</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/statistic/callDailyStatistic/">外呼统计分析</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1" href="${ctx}/statistic/salesConversionReport/">销售转化报表分析</a>
                                                </li>
                                                <shiro:hasPermission name="CJTJ">
                                                    <li>
                                                        <a tabindex="-1"
                                                           href="${ctx}/statistic/transactionStatusReport/">成交状态抽查报表</a>
                                                    </li>
                                                </shiro:hasPermission>
                                                <li>
                                                    <a tabindex="-1" href="${ctx}/statistic/cloudCusReport/">云迹数据统计表</a>
                                                </li>
                                                <shiro:hasPermission name="CBTS">
                                                    <li>
                                                        <a tabindex="-1"  href="${ctx}/statistic/callBackTraceStatistic/">回访跟进统计</a>
                                                    </li>
                                                </shiro:hasPermission>
                                            </ul>
                                        </li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="GGGL">
                                        <li><a href="${ctx}/notice/">公告管理</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="DKPJ">
                                        <li><a href="${ctx}/evaluateusercustomerlog/">带看评价</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="ZYBG">
                                        <li><a href="${ctx}/propertyreport/list">我的置业报告</a></li>
                                    </shiro:hasPermission>
                                </ul>
                            </li>
                        </shiro:hasPermission>
                        <shiro:hasPermission
                                name="WDKH or WDKHNEW or HOTLINE or ZZJG:USERS or ZXRBTX or MARKETACTIVE or HFLY or EXTERNALCUS or PTKH">
                            <li class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#" id="customer_menu">客户管理 <b
                                        class="caret"></b></a>
                                <ul class="dropdown-menu" aria-labelledby="customer_menu">
                                    <shiro:hasPermission name="WDKHNEW">
                                        <li class="dropdown-submenu">
                                            <a tabindex="-1" href="#">我的客户</a>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/customermanagement/myCustomerNew?type=waitCall&search_EQ_orderByTime=3">待回访</a>
                                                </li>
                                                    <%--<c:if test="${city == 'nj'}">--%>
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/customermanagement/myCustomerNew?type=cloud&search_EQ_orderByTime=5">云迹</a>
                                                </li>
                                                    <%--</c:if>--%>
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/customermanagement/myCustomerNew?type=&search_EQ_orderByTime=5">全部</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/customermanagement/myCustomerNew?type=newadd&search_EQ_orderByTime=5">新增</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/customermanagement/myCustomerNew?type=callback&search_EQ_orderByTime=5">回访</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/customermanagement/myCustomerNew?type=valid&search_EQ_orderByTime=5">有效</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/customermanagement/myCustomerNew?type=deal&search_EQ_orderByTime=5">成交</a>
                                                </li>
                                                <c:if test="${sessionCurrDept.id ne 2}">
                                                    <li><a tabindex="-1"
                                                           href="${ctx}/customermanagement/myCustomerNew?type=respite&search_EQ_orderByTime=5">暂缓</a>
                                                    </li>
                                                </c:if>
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/customermanagement/myCustomerNew?type=handover&search_EQ_orderByTime=5">交接</a>
                                                </li>
                                                <li>
                                                    <a tabindex="-1"
                                                       href="${ctx}/customermanagement/myCustomerNew?type=active&search_EQ_orderByTime=5">活跃</a>
                                                </li>
                                            </ul>
                                        </li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="WDKH">
                                        <li><a href="${ctx}/customer/myCustomer">我的客户-OLD</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="HOTLINE">
                                        <li><a href="${ctx}/customer/hotlineList">我的400来电</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="ZZJG:USERS">
                                        <li><a href="${ctx}/manager">置业顾问管理</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="ZXRBTX">
                                        <li><a tabindex="-1"
                                               href="${ctx}/reportmarketing/daily?type=reportmarketing">直销日报填写</a>
                                        </li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="MARKETACTIVE">
                                        <li><a href="${ctx}/marketingactivity">客户营销</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="HFLY">
                                        <li><a href="${ctx}/callbackrecord">回访录音</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="WDKHTJ">
                                        <li><a href="${ctx}/customermanagement/customerCount">我的客户统计</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="CLOUDACTIVITY">
                                        <li><a href="${ctx}/cloudactivity/list">云迹数据</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="CLOUDPULL">
                                        <li><a href="${ctx}/cloudactivity/pullList">云迹拉取数据</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="EXTERNALCUS">
                                        <li><a href="${ctx}/externalCustomer/list">外部客户</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="PTKH">
                                        <li><a href="${ctx}/platformmanagement/myPlatformCustomer">平台客户</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="SUCCESSCUS">
                                        <li><a href="${ctx}/customermanagement/successList">成交客户</a></li>
                                    </shiro:hasPermission>
                                </ul>
                            </li>
                        </shiro:hasPermission>
                        <shiro:hasPermission name="WDZCXM or XMLB or XMRBTX or XMDT">
                            <li class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#" id="project_menu">项目管理 <b
                                        class="caret"></b></a>
                                <ul class="dropdown-menu" aria-labelledby="project_menu">
                                    <shiro:hasPermission name="WDZCXM">
                                        <li><a href="${ctx}/project/myProjects">我的驻场项目</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="XMLB">
                                        <li><a href="${ctx}/project?search_EQ_cityName=${sessionCurrDept.name}">项目管理</a>
                                        </li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="XMRBTX">
                                        <li><a tabindex="-1"
                                               href="${ctx}/reportmarketing/daily?type=localreport">项目日报填写</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="XMDT">
                                        <li><a tabindex="-1"
                                               href="${ctx}/project/projectdynamic">项目动态</a></li>
                                    </shiro:hasPermission>
                                </ul>
                            </li>
                        </shiro:hasPermission>
                        <shiro:hasPermission name="ZZJG or QXZGL or QXGL or BBGL or DLSQGL">
                            <li class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#" id="department_menu">组织架构
                                    <b class="caret"></b>
                                </a>
                                <ul class="dropdown-menu" aria-labelledby="department_menu">
                                    <shiro:hasPermission name="ZZJG">
                                        <li><a href="${ctx}/department/main">组织架构</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="QXZGL">
                                        <li><a href="${ctx}/role">权限组管理</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="BBGL">
                                        <li><a href="${ctx}/appversion">版本管理</a></li>
                                    </shiro:hasPermission>

                                    <shiro:hasPermission name="QXGL">
                                        <li><a href="${ctx}/permission">权限管理</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="DLSQGL">
                                        <li><a href="${ctx}/authorization">登陆授权管理</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="IMTZGL">
                                        <li><a href="${ctx}/userrole/wxUserList">IM通知人员管理</a></li>
                                    </shiro:hasPermission>
                                </ul>
                            </li>
                        </shiro:hasPermission>
                        <shiro:hasPermission name="GRXX or XGMM or LABEL">
                            <li class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#" id="account_menu">账户管理 <b
                                        class="caret"></b></a>
                                <ul class="dropdown-menu" aria-labelledby="account_menu">
                                    <shiro:hasPermission name="GRXX">
                                        <li><a href="${ctx}/role/edit/${sessionUserId}">个人信息</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="XGMM">
                                        <li><a href="${ctx}/toEditPasswd">修改密码</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="RECOMMENDHOUSE">
                                        <li><a href="${ctx}/userprojectrecommend">个人楼盘推荐</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="LABEL">
                                        <li><a href="${ctx}/labelmanager">标签管理</a></li>
                                    </shiro:hasPermission>
                                </ul>
                            </li>
                        </shiro:hasPermission>
                        <shiro:hasPermission
                                name="SJBSC or HDLYGL or REMOVETIME or REPORTCHANNEL or CITYDEPTCONFIG or SCJD or GGWPZ or PTKHFPGZ">
                            <li class="dropdown">
                                <a class="dropdown-toggle" data-toggle="dropdown" href="#" id="system_menu">系统设置 <b
                                        class="caret"></b></a>

                                <ul class="dropdown-menu" aria-labelledby="system_menu">
                                    <shiro:hasPermission name="HDLYGL">
                                        <li><a href="${ctx}/customersource">活动来源设置</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="SJBSC">
                                        <li><a href="${ctx}/report">概览报表设置</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="REMOVETIME">
                                        <li><a href="${ctx}/dictionary/removeTime/removeTimeList">客户保护设置</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="REPORTCHANNEL">
                                        <li><a tabindex="-1" href="${ctx}/reportchannel">渠道管理</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="CITYDEPTCONFIG">
                                        <li><a href="${ctx}/citydepconfig">城市部门配置</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="CRMSOURCE">
                                        <li><a href="${ctx}/basetree/main?sourceType=crmsource">CRM客户来源</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="RUSHRULE">
                                        <li><a href="${ctx}/rushcustomerrule">抢客规则</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="SCJD">
                                        <li><a href="${ctx}/repoetattach/marketAttach">市场解读</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="GGWPZ">
                                        <li><a href="${ctx}/repoetattach/adAttach">广告位配置</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="PTKHFPGZ">
                                        <li><a href="${ctx}/platformmanagement/ruleList">平台客户分配规则</a></li>
                                    </shiro:hasPermission>
                                    <shiro:hasPermission name="PLZYKH">
                                        <li><a href="${ctx}/transfercustomer">批量转移客户</a></li>
                                    </shiro:hasPermission>
                                </ul>

                            </li>
                        </shiro:hasPermission>
                    </ul>

                    <c:if test="${sessionOriginDept.hierarchy eq 0}">
                        <div style="float:right;margin-top:5px">
                            <select name="currentDept" id="currentDept" class="span12">
                                <c:forEach items="${deptList}" var="dept">
                                    <option value="${dept.id}"
                                            <c:if test="${dept.id eq sessionCurrDept.id}">selected="selected"</c:if>>
                                            ${dept.name}</option>
                                </c:forEach>
                            </select>
                        </div>
                    </c:if>
                </div>

                <div class="nav-collapse collapse">
                    <ul class="nav" role="menu" aria-labelledby="dLabel">
                        <c:if test="${sessionOriginDept.hierarchy != 0}">
                            <li class="dropdown"><a><span class="label label-default">${sessionCurrDept.name}</span></a>
                            </li>
                        </c:if>

                        <li class="dropdown" style="margin-left: 10px;margin-top: 7px;">
        <span class="label label-default" id="info" data-target="#">
        <img style="width: 20px;" src="${static_common}/img/news.png">
        </span>
                            <div class="dropdown-menu info-menu" aria-labelledby="info">
                                <div class="info-content"></div>
                            </div>
                            <div id="spanContent"></div>
                            <%--<span class='num2'>${tipSize}</span>--%>
                        </li>
                        <li class="dropdown"><a><span class="label label-default">${sessionUserName}</span></a></li>
                        <li class="dropdown"><a href="${ctx }/logout">退出</a></li>
                    </ul>
                </div>

            </div>
        </div>
    </div>

</div>

<div class="modal fade" id="newsModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
     aria-hidden="false" style="width: 400px;position: absolute;left: 90%;height:300px;overflow:hidden;display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-body" style="max-height: 300px;">
                <div>
                    <div class="tab-content" id="summaryContent" style="padding: 0px 15px;"></div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function () {
        $("#currentDept").on("change", function (e) {
            var deptId = $(this).val();
            // var cityName = $("#currentCity option[@selected]").text();
            // console.log(cityCode+","+cityName);
            $.ajax({
                url: '${ctx}/changeDept/' + deptId,
                type: "GET",
                success: function () {
                    // console.log(deptId);
                    window.location = "${ctx}/";
                }
            });

        });
    });

    self.setInterval(function () {
        var date = new Date();
        var minute = date.getMinutes();
        if (minute == '00' || minute == '10' || minute == '20' || minute == '30' || minute == '40' || minute == '50' || minute == '0') {
            showModal(function () {
                $('#info').dropdown('toggle');
            })
        }
        // console.log(minute);
    }, 60000);

    $(document).ready(function () {
        $.ajax({
            url: "${ctx}/customermanagement/newsList",
            data: '',
            type: "get",
            dataType: 'json',
            success: function (result) {
                if (result.status == 0) {
                    var newsList = result.data;
                    var spanHtml = '';
                    if (newsList.length > 0) {
                        spanHtml += '<span class="num2">' + newsList.length + ' </span>';
                        $("#spanContent").html(spanHtml);
                    }
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    });

    function showModal(cb) {
        $.ajax({
            url: "${ctx}/customermanagement/newsList",
            data: '',
            type: "get",
            dataType: 'json',
            success: function (result) {
                if (result.status == 0) {
                    var newsList = result.data;
                    var html = '';
                    var spanHtml = '';
                    if (newsList.length > 0) {
                        $.each(newsList, function (i, e) {
                            html += '<div><span>跟进提醒</span><span style="margin-left: 100px;">' + e.returnRemindTime + '</span></div>';
                            html += '<div>您的客户[' + '<span style="color: #0e90d2">' + e.customerName + '</span>' + ']需要跟进了，<a href="javascript:void(0)" onclick="toDelete(' + e.id + ',' + e.customerId + ')">立即前往~</a></div>';
                            html += '<div><hr style="border: 1px solid black;"/></div>';
                        });
                        spanHtml += '<span class="num2">' + newsList.length + ' </span>';
                        $("#spanContent").html(spanHtml);
                        $(".info-content").html(html);
                        if (typeof cb == 'function') {
                            cb()
                        }
                    }
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    }

    function renderInfoMenu(cb) {
        $.ajax({
            url: "${ctx}/customermanagement/newsList",
            data: '',
            type: "get",
            dataType: 'json',
            success: function (result) {
                if (result.status == 0) {
                    var newsList = result.data;
                    var html = '';
                    var spanHtml = '';
                    if (newsList.length > 0) {
                        $.each(newsList, function (i, e) {
                            html += '<div><span>跟进提醒</span><span style="margin-left: 100px;">' + e.returnRemindTime + '</span></div>';
                            html += '<div>您的客户[' + '<span style="color: #0e90d2">' + e.customerName + '</span>' + ']需要跟进了，<a href="javascript:void(0)" onclick="toDelete(' + e.id + ',' + e.customerId + ')">立即前往~</a></div>';
                            html += '<div><hr style="border: 1px solid black;"/></div>';
                        });
                        spanHtml += '<span class="num2">' + newsList.length + ' </span>';
                        $("#spanContent").html(spanHtml);
                    } else {
                        html += '<div><span>暂无提醒消息</span></div>';
                    }

                    $(".info-content").html(html);
                    if (typeof cb == 'function') {
                        cb()
                    }
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    }

    $('#info').click(function (e) {
        e.stopPropagation();
        renderInfoMenu(function () {
            $('#info').dropdown('toggle');
        })
    });

    function toDelete(id, customerId) {
        $.ajax({
            url: "${ctx}/customermanagement/deleteTips/" + id,
            data: '',
            type: "POST",
            dataType: 'json',
            success: function (result) {
                if (result.status == 0) {
                    $.ajax({
                        url: "${ctx}/customermanagement/newsList",
                        data: '',
                        type: "get",
                        dataType: 'json',
                        success: function (result) {
                            if (result.status == 0) {
                                var newsList = result.data;
                                var spanHtml = '';
                                if (newsList.length > 0) {
                                    spanHtml += '<span class="num2">' + newsList.length + ' </span>';
                                    $("#spanContent").html(spanHtml);
                                    $("#newsModal").modal('hide');
                                } else {
                                    $("#spanContent").html('');
                                    $("#newsModal").modal('hide');
                                }
                                window.open("/house365-hgs-web/customer/customerInfo?action=edit&customerId=" + customerId, "_blank");
                            } else {
                                alert(data.errorMessage);
                            }
                        }
                    });

                } else {
                    alert(data.errorMessage);
                }
            }
        });
    }

</script>
<style>
    .num2 {
        font-size: 12px;
        position: absolute;
        margin-top: -32px;
        width: 20px;
        background: red;
        color: #fff;
        padding: 1px 3px;
        height: 20px;
        min-width: 20px;
        line-height: 19px;
        text-align: center;
        border-radius: 10px;
        left: 20px;
    }

    .info-menu {
        width: 400px;
        height: 300px;
    }

    .info-content {
        width: 394px;
        height: 285px;
        padding: 15px;
        overflow: auto;
    }
</style>

<!-- HEADER END -->
