package com.house365.web.util;

import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.CustomerLogEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.web.cached.RedisUtilsInterface;
import com.house365.ws.interfaces.server.ICustomerProject;
import com.house365.ws.interfaces.server.IDictionary;
import com.house365.ws.interfaces.server.IUser;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 操作流程日志
 * 客户来源信息
 */
public class UserUtil {

//    private static RedisUtilsInterface redisUtil = (RedisUtilsInterface) SpringContextUtil.getBean("redisUtils");

    private static IUser iuser = (IUser) SpringContextUtil.getBean("user");

    private static ICustomerProject cp = (com.house365.ws.interfaces.server.ICustomerProject) SpringContextUtil.getBean("customerProject");

    /**
     * 操作日志记录
     * @param logShowList
     * @param list
     * @return
     */
    public static List<String> addOperateLog(List<String> logShowList, List<CustomerLogEntity> list){
        if (CollectionUtils.isNotEmpty(list)) {
            for (CustomerLogEntity p : list) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                //获取String类型的时间
                String showTime = sdf.format(p.getCreateTime());
                if (p.getType() == 1) {
                    String showWord = showTime + "  " + p.getCreateUserName() + " [新增客户]";
                    logShowList.add(showWord);
                } else if (p.getType() == 2) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(showTime).append("   ").append(p.getCreateUserName()).append("  [编辑客户]  ");
                    builder.append("将  '").append(p.getModifyName()).append("'  由  '").append(p.getOldValue())
                            .append("'  修改为  '").append(p.getNewValue()).append("' , ");
                    logShowList.add(builder.toString().substring(0, builder.toString().lastIndexOf(",")));
                } else if (p.getType() == 3) {
                    String showWord = showTime + "  " + p.getCreateUserName() + " [删除客户]";
                    logShowList.add(showWord);
                } else if (p.getType() == 4) {
                    //营销活动派工
                    String showWord = showTime + "  " + p.getCreateUserName() + " [营销活动-派工客户]" + "给  ";
                    if (StringUtils.isNotBlank(p.getNewValue())) {
                        UserEntity showUser = iuser.getById(Integer.valueOf(p.getNewValue()));
                        if (null != showUser) {
                            showWord = showWord + showUser.getRealName();
                        }
                    }
                    logShowList.add(showWord);
                } else if (p.getType() == 5) {
                    //公海派工
                    String showWord = showTime + "  " + p.getCreateUserName() + " [公海-派工客户]" + "给  ";
                    if (StringUtils.isNotBlank(p.getNewValue())) {
                        UserEntity showUser = iuser.getById(Integer.valueOf(p.getNewValue()));
                        if (null != showUser) {
                            showWord = showWord + showUser.getRealName();
                        }
                    }
                    logShowList.add(showWord);
                } else if (p.getType() == 6) {
                    //移入派工
                    String showWord = showTime + "  " + p.getCreateUserName() + " [移入公海]";
                    logShowList.add(showWord);
                } else if (p.getType() == 7) {
                    //转移客户
                    String showWord = showTime + "  " + p.getCreateUserName() + " [转移客户]" + "给  ";
                    if (StringUtils.isNotBlank(p.getNewValue())) {
                        UserEntity showUser = iuser.getById(Integer.valueOf(p.getNewValue()));
                        if (null != showUser) {
                            showWord = showWord + showUser.getRealName();
                        }
                    }
                    logShowList.add(showWord);
                } else if (p.getType() == 8) {
                    //无变动
                    String showWord = showTime + "  " + p.getCreateUserName() + " [无变动]";
                    logShowList.add(showWord);
                } else if (p.getType() == 9) {
                    //云迹活动派工
                    String showWord = showTime + "  " + p.getCreateUserName() + " [云迹活动-派工客户]" + " 给 ";
                    UserEntity showUser = iuser.getById(Integer.valueOf(p.getNewValue()));
                    if (null != showUser) {
                        showWord = showWord + showUser.getRealName();
                    }
                    logShowList.add(showWord);
                }else if(p.getType() == 11){
                    //平台客户管理转移创建人
                    String showWord = showTime + "  " + p.getCreateUserName() + " [转移线索]" + "给 ";
                    UserEntity showUser = iuser.getById(Integer.valueOf(p.getNewValue()));
                    if (null != showUser) {
                        showWord = showWord + showUser.getRealName();
                    }
                    logShowList.add(showWord);
                }
//                else if (p.getType() == 10) {
//                    //项目转移
//                    String showWord = showTime + "  " + "【项目转移】, 添加人【" + p.getCreateUserName() + "】 ," + "备注 【 从" + p.getOldValue() + "转移到" + p.getNewValue() +"】";
////                    UserEntity showUser = iuser.getById(Integer.valueOf(p.getNewValue()));
//                    logShowList.add(showWord);
//                }

            }
        }
        return logShowList;
    }

    /**
     * 展示来源类型
     * @param oldList
     * @return
     */
    public static List<CustomerEntity> showCreateSource(List<CustomerEntity> oldList){
        if (CollectionUtils.isNotEmpty(oldList)) {
            Collections.reverse(oldList);
            for (CustomerEntity c : oldList) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank(c.getCreateSource())) {
                    if ("CRM拉取".equals(c.getCreateSource())) {
                        c.setCreateSource("营销活动");
                    } else if ("SYSTEM".equals(c.getCreateSource()) || "WECHAT".equals(c.getCreateSource())) {
                        c.setCreateSource("手动添加");
                    } else if ("HOTLINE".equals(c.getCreateSource())) {
                        c.setCreateSource("400来电");
                    } else if ("PT".equals(c.getCreateSource())) {
                        c.setCreateSource("平台导入");
                    }
                }
            }
        }
        return oldList;
    }

    /**
     * 展示来源类型
     * @return
     */
    public static CustomerEntity showCreateSource(CustomerEntity customerEntity){
        if ("CRM拉取".equals(customerEntity.getCreateSource())) {
            customerEntity.setCreateSource("营销活动");
        } else if ("SYSTEM".equals(customerEntity.getCreateSource()) || "WECHAT".equals(customerEntity.getCreateSource())) {
            customerEntity.setCreateSource("手动添加");
        } else if ("HOTLINE".equals(customerEntity.getCreateSource())) {
            customerEntity.setCreateSource("400来电");
        } else if ("PT".equals(customerEntity.getCreateSource())) {
            customerEntity.setCreateSource("平台导入");
        }
        return customerEntity;
    }

    /**
     * 平台展示-客户状态
     * @param customerEntity
     * @param cpMap
     * @return
     */
    public static CustomerEntity showPlatCustomerStatus(CustomerEntity customerEntity, Map<String, Object> cpMap){
        int status = cp.queryPlatCustomerStatus(cpMap);
        if (status == 0) {
            customerEntity.setPlatCustomerStatus("跟进中");
        }
        if (status == 1) {
            customerEntity.setPlatCustomerStatus("约看");
        }
        if (status == 2) {
            customerEntity.setPlatCustomerStatus("到访");
        }
        if (status == 3) {
            customerEntity.setPlatCustomerStatus("认筹");
        }
        if (status == 4) {
            customerEntity.setPlatCustomerStatus("认购");
        }
        if (status == 5) {
            customerEntity.setPlatCustomerStatus("签约");
        }
        if (status == 6) {
            customerEntity.setPlatCustomerStatus("退房");
        }
        return customerEntity;
    }
}
