/**
 * Description: 营销活动页面表单对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:20:59
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.house365.beans.entity.MarketingActivityEntity;
import com.house365.beans.system.DomainObject;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 营销活动页面表单对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public class MarketingActivityVo extends DomainObject {

    private static final long serialVersionUID = 1L;
    /**
     * 营销活动实体
     */
    @NotNull
    @Valid
    private MarketingActivityEntity entity;

    private String buildingName;

    private String blockName;

    private String activityName;

    private String activityType;

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    private String districtName;

    public String getBlockName() {
        return blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public String getDistrictName() {
        return districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    private String buildingId;

    private String signTime;

    private String step;

    private String total;

    //浏览轨迹参数
    private String projectId;

    private String projectName;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date seeStartTime;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date seeEndTime;

    private String signTimeNew;

    private int seeCount;

    public String getTotal() {
        return total;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public String getStep() {
        return step;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public String getSignTime() {
        return signTime;
    }

    public void setSignTime(String signTime) {
        this.signTime = signTime;
    }

    public String getBuildingId() {
        return buildingId;
    }

    public void setBuildingId(String buildingId) {
        this.buildingId = buildingId;
    }

    public String getBuildingName() {
        return buildingName;
    }

    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    /**
     * 设置营销活动实体
     * @param entity 营销活动实体
     */
    public void setEntity(MarketingActivityEntity entity) {
        this.entity = entity;
    }

    /**
     * 获取营销活动实体
     * @return 营销活动实体
     */
    public MarketingActivityEntity getEntity() {
        return this.entity;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getSeeStartTime() {
        return seeStartTime;
    }

    public void setSeeStartTime(Date seeStartTime) {
        this.seeStartTime = seeStartTime;
    }

    public Date getSeeEndTime() {
        return seeEndTime;
    }

    public void setSeeEndTime(Date seeEndTime) {
        this.seeEndTime = seeEndTime;
    }

    public String getSignTimeNew() {
        return signTimeNew;
    }

    public void setSignTimeNew(String signTimeNew) {
        this.signTimeNew = signTimeNew;
    }

    public int getSeeCount() {
        return seeCount;
    }

    public void setSeeCount(int seeCount) {
        this.seeCount = seeCount;
    }
}
