/**
 * Description: 抢客客户项目关联数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-26 下午 16:57:26
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-26   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * 抢客客户项目关联数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-26
 * @see
 * @since 1.0
 */
public class RushCustomerProjectRelEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 抢客客户id
     */

    private Integer rushCustomerId;

    /**
     * 项目id
     */

    private Integer projectId;

    /**
     * 项目名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String projectName;

    //columns END
    /*
	public RushCustomerProjectRel(){
	}

	public RushCustomerProjectRel(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 获取抢客客户id
     * @return 抢客客户id
     */
    public Integer getRushCustomerId() {
        return this.rushCustomerId;
    }

    /**
     * 设置抢客客户id
     * @param rushCustomerId 抢客客户id
     */
    public void setRushCustomerId(Integer rushCustomerId) {
        this.rushCustomerId = rushCustomerId;
    }

    /**
     * 获取项目id
     * @return 项目id
     */
    public Integer getProjectId() {
        return this.projectId;
    }

    /**
     * 设置项目id
     * @param projectId 项目id
     */
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取项目名称
     * @return 项目名称
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * 设置项目名称
     * @param projectName 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("RushCustomerId", getRushCustomerId())
                .append("ProjectId", getProjectId())
                .append("ProjectName", getProjectName())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof RushCustomerProjectRelEntity == false) return false;
        if (this == obj) return true;
        RushCustomerProjectRelEntity other = (RushCustomerProjectRelEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

