/**
 * Description: ProjectSaler数据库实体/领域对象
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-02-01 上午 09:10:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-02-01   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * ProjectSaler数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-02-01
 * @see
 * @since 1.0
 */
public class ProjectSalerEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 项目ID
     */
    private Integer projectId;

    /**
     * 项目编号
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String projectCode;

    /**
     * 项目名称
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String projectName;

    /**
     * 直销人员ID
     */
    private Integer userId;

    /**
     * 直销人员名称
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String userName;

    /**
     * 创建人用户ID
     */
    private Integer createUserid;

    /**
     * 创建人用户名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String createUsername;

    /**
     * 创建时间
     */
    private java.util.Date createTime;

    /**
     * 创建人电脑IP
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    private String createIp;

    /**
     * 最后一次修改人用户ID
     */
    private Integer updateUserid;

    /**
     * 最后一次修改人用户名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String updateUsername;

    /**
     * 最后一次修改时间
     */
    private java.util.Date updateTime;

    /**
     * 最后一次修改人电脑IP
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    private String updateIp;

    /**
     * 物业类型
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String channel;

    /**
     * 城市
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String city;


    /**
     * 获取项目ID
     * @return 项目ID
     */
    public Integer getProjectId() {
        return this.projectId;
    }

    /**
     * 设置项目ID
     * @param projectId 项目ID
     */
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取项目编号
     * @return 项目编号
     */
    public String getProjectCode() {
        return this.projectCode;
    }

    /**
     * 设置项目编号
     * @param projectCode 项目编号
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 获取项目名称
     * @return 项目名称
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * 设置项目名称
     * @param projectName 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 获取直销人员ID
     * @return 直销人员ID
     */
    public Integer getUserId() {
        return this.userId;
    }

    /**
     * 设置直销人员ID
     * @param userId 直销人员ID
     */
    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    /**
     * 获取直销人员名称
     * @return 直销人员名称
     */
    public String getUserName() {
        return this.userName;
    }

    /**
     * 设置直销人员名称
     * @param userName 直销人员名称
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取创建人用户ID
     * @return 创建人用户ID
     */
    public Integer getCreateUserid() {
        return this.createUserid;
    }

    /**
     * 设置创建人用户ID
     *
     * @param createUserid 创建人用户ID
     */
    public void setCreateUserid(Integer createUserid) {
        this.createUserid = createUserid;
    }

    /**
     * 获取创建人用户名
     * @return 创建人用户名
     */
    public String getCreateUsername() {
        return this.createUsername;
    }

    /**
     * 设置创建人用户名
     * @param createUsername 创建人用户名
     */
    public void setCreateUsername(String createUsername) {
        this.createUsername = createUsername;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建时间
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取创建人电脑IP
     *
     * @return 创建人电脑IP
     */
    public String getCreateIp() {
        return this.createIp;
    }

    /**
     * 设置创建人电脑IP
     *
     * @param createIp 创建人电脑IP
     */
    public void setCreateIp(String createIp) {
        this.createIp = createIp;
    }

    /**
     * 获取最后一次修改人用户ID
     *
     * @return 最后一次修改人用户ID
     */
    public Integer getUpdateUserid() {
        return this.updateUserid;
    }

    /**
     * 设置最后一次修改人用户ID
     *
     * @param updateUserid 最后一次修改人用户ID
     */
    public void setUpdateUserid(Integer updateUserid) {
        this.updateUserid = updateUserid;
    }

    /**
     * 获取最后一次修改人用户名
     *
     * @return 最后一次修改人用户名
     */
    public String getUpdateUsername() {
        return this.updateUsername;
    }

    /**
     * 设置最后一次修改人用户名
     *
     * @param updateUsername 最后一次修改人用户名
     */
    public void setUpdateUsername(String updateUsername) {
        this.updateUsername = updateUsername;
    }

    /**
     * 设置最后一次修改时间字符串格式
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后一次修改时间
     * @return 最后一次修改时间
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置最后一次修改时间
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取最后一次修改人电脑IP
     *
     * @return 最后一次修改人电脑IP
     */
    public String getUpdateIp() {
        return this.updateIp;
    }

    /**
     * 设置最后一次修改人电脑IP
     *
     * @param updateIp 最后一次修改人电脑IP
     */
    public void setUpdateIp(String updateIp) {
        this.updateIp = updateIp;
    }

    /**
     * 获取物业类型
     *
     * @return 物业类型
     */
    public String getChannel() {
        return this.channel;
    }

    /**
     * 设置物业类型
     *
     * @param channel 物业类型
     */
    public void setChannel(String channel) {
        this.channel = channel;
    }

    /**
     * 获取城市
     *
     * @return 城市
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置城市
     *
     * @param city 城市
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("ProjectId", getProjectId())
                .append("ProjectCode", getProjectCode())
                .append("ProjectName", getProjectName())
                .append("UserId", getUserId())
                .append("UserName", getUserName())
                .append("CreateUserid", getCreateUserid())
                .append("CreateUsername", getCreateUsername())
                .append("CreateTime", getCreateTime())
                .append("CreateIp", getCreateIp())
                .append("UpdateUserid", getUpdateUserid())
                .append("UpdateUsername", getUpdateUsername())
                .append("UpdateTime", getUpdateTime())
                .append("UpdateIp", getUpdateIp())
                .append("Channel", getChannel())
                .append("City", getCity())
                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProjectSalerEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ProjectSalerEntity other = (ProjectSalerEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

