/**
 * Description: EvaluateUserCustomerLog数据库实体/领域对象
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-02-02 上午 11:21:10
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-02-02   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * EvaluateUserCustomerLog数据库实体/领域对象<br>评估用户客户日志
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-02-02
 * @see
 * @since 1.0
 */
public class EvaluateUserCustomerLogEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 直销人员id
     */
    private Integer userId;

    /**
     * 直销人员姓名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String userName;

    /**
     * 楼盘id
     */
    private Integer projectId;

    /**
     * 楼盘名称
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String projectName;

    /**
     * 客户姓名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String customerName;

    /**
     * 评分
     */
    private Integer score;

    /**
     * 评价内容
     */
    @Length(max = 255, message = "长度需要大于0且小于255")
    private String content;

    private String contentTags;

    public String getContentTags() {
        return contentTags;
    }

    public void setContentTags(String contentTags) {
        this.contentTags = contentTags;
    }

    /**
     * 删除标记 0：未删除；1：已删除；
     */
    private Integer isDeleted;

    /**
     * 是否已评价 0：未评价；1：已评价；
     */
    private Integer isEvaluated;

    /**
     * 审核状态 0：待审核；1：审核通过；2：审核不通过；
     */
    private Integer checkStatus;

    /**
     * 带看创建时间
     */
    private java.util.Date createTime;

    /**
     * 客户评价时间
     */
    private java.util.Date evaluateTime;

    /**
     * 带看创建时间
     */
    private String createDateStr;

    /**
     * 客户评价时间
     */
    private String evaluateDateStr;

    /**
     * 审核时间
     */
    private java.util.Date checkTime;

    /**
     * 审核人
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String checkMan;

    /**
     * 城市
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String city;

    private Integer channel;

    public String getCreateDateStr() {
        return createDateStr;
    }

    public void setCreateDateStr(String createDateStr) {
        this.createDateStr = createDateStr;
    }

    public String getEvaluateDateStr() {
        return evaluateDateStr;
    }

    public void setEvaluateDateStr(String evaluateDateStr) {
        this.evaluateDateStr = evaluateDateStr;
    }

    /**
     * 获取直销人员id
     *
     * @return 直销人员id
     */
    public Integer getUserId() {
        return this.userId;
    }

    /**
     * 设置直销人员id
     *
     * @param userId 直销人员id
     */
    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    /**
     * 获取直销人员姓名
     *
     * @return 直销人员姓名
     */
    public String getUserName() {
        return this.userName;
    }

    /**
     * 设置直销人员姓名
     *
     * @param userName 直销人员姓名
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取楼盘id
     *
     * @return 楼盘id
     */
    public Integer getProjectId() {
        return this.projectId;
    }

    /**
     * 设置楼盘id
     *
     * @param projectId 楼盘id
     */
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取楼盘名称
     *
     * @return 楼盘名称
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * 设置楼盘名称
     *
     * @param projectName 楼盘名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 获取客户姓名
     *
     * @return 客户姓名
     */
    public String getCustomerName() {
        return this.customerName;
    }

    /**
     * 设置客户姓名
     *
     * @param customerName 客户姓名
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    /**
     * 获取评分
     *
     * @return 评分
     */
    public Integer getScore() {
        return this.score;
    }

    /**
     * 设置评分
     *
     * @param score 评分
     */
    public void setScore(Integer score) {
        this.score = score;
    }

    /**
     * 获取评价内容
     *
     * @return 评价内容
     */
    public String getContent() {
        return this.content;
    }

    /**
     * 设置评价内容
     *
     * @param content 评价内容
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 获取删除标记 0：未删除；1：已删除；
     *
     * @return 删除标记 0：未删除；1：已删除；
     */
    public Integer getIsDeleted() {
        return this.isDeleted;
    }

    /**
     * 设置删除标记 0：未删除；1：已删除；
     *
     * @param isDeleted 删除标记 0：未删除；1：已删除；
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * 获取是否已评价 0：未评价；1：已评价；
     *
     * @return 是否已评价 0：未评价；1：已评价；
     */
    public Integer getIsEvaluated() {
        return this.isEvaluated;
    }

    /**
     * 设置是否已评价 0：未评价；1：已评价；
     *
     * @param isEvaluated 是否已评价 0：未评价；1：已评价；
     */
    public void setIsEvaluated(Integer isEvaluated) {
        this.isEvaluated = isEvaluated;
    }

    /**
     * 获取审核状态 0：待审核；1：审核通过；2：审核不通过；
     *
     * @return 审核状态 0：待审核；1：审核通过；2：审核不通过；
     */
    public Integer getCheckStatus() {
        return this.checkStatus;
    }

    /**
     * 设置审核状态 0：待审核；1：审核通过；2：审核不通过；
     *
     * @param checkStatus 审核状态 0：待审核；1：审核通过；2：审核不通过；
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * 设置带看创建时间字符串格式
     *
     * @param createTime 带看创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取带看创建时间
     *
     * @return 带看创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置带看创建时间
     *
     * @param createTime 带看创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置客户评价时间字符串格式
     *
     * @param evaluateTime 客户评价时间
     */
    public void setEvaluateTimeStr(String evaluateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(evaluateTime)) {
            try {
                this.evaluateTime = java.text.DateFormat.getDateTimeInstance().parse(evaluateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取客户评价时间
     *
     * @return 客户评价时间
     */
    public java.util.Date getEvaluateTime() {
        return this.evaluateTime;
    }

    /**
     * 设置客户评价时间
     *
     * @param evaluateTime 客户评价时间
     */
    public void setEvaluateTime(java.util.Date evaluateTime) {
        this.evaluateTime = evaluateTime;
    }

    /**
     * 设置审核时间字符串格式
     *
     * @param checkTime 审核时间
     */
    public void setCheckTimeStr(String checkTime) {
        if (!com.house365.web.util.StringUtils.isBlank(checkTime)) {
            try {
                this.checkTime = java.text.DateFormat.getDateTimeInstance().parse(checkTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取审核时间
     *
     * @return 审核时间
     */
    public java.util.Date getCheckTime() {
        return this.checkTime;
    }

    /**
     * 设置审核时间
     *
     * @param checkTime 审核时间
     */
    public void setCheckTime(java.util.Date checkTime) {
        this.checkTime = checkTime;
    }

    /**
     * 获取审核人
     *
     * @return 审核人
     */
    public String getCheckMan() {
        return this.checkMan;
    }

    /**
     * 设置审核人
     *
     * @param checkMan 审核人
     */
    public void setCheckMan(String checkMan) {
        this.checkMan = checkMan;
    }

    /**
     * 获取城市
     *
     * @return 城市
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置城市
     *
     * @param city 城市
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 获取channel
     *
     * @return channel
     */
    public Integer getChannel() {
        return this.channel;
    }

    /**
     * 设置channel
     *
     * @param channel channel
     */
    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("UserId", getUserId())
                .append("UserName", getUserName())
                .append("ProjectId", getProjectId())
                .append("ProjectName", getProjectName())
                .append("CustomerName", getCustomerName())
                .append("Score", getScore())
                .append("Content", getContent())
                .append("IsDeleted", getIsDeleted())
                .append("IsEvaluated", getIsEvaluated())
                .append("CheckStatus", getCheckStatus())
                .append("CreateTime", getCreateTime())
                .append("EvaluateTime", getEvaluateTime())
                .append("CheckTime", getCheckTime())
                .append("CheckMan", getCheckMan())
                .append("City", getCity())
                .append("Channel", getChannel())
                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EvaluateUserCustomerLogEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        EvaluateUserCustomerLogEntity other = (EvaluateUserCustomerLogEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

