/**
 * Description: 客户状态变更纪录数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-19 下午 14:08:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-19   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 客户状态变更纪录数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-19
 * @see
 * @since 1.0
 */
public class CustomerStatusLogEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 变更前状态 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */

    private Integer fromStatusId;

    /**
     * 变更后状态 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */

    private Integer toStatusId;

    /**
     * 变更前状态名称 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String fromStatusName;

    /**
     * 变更后状态名称 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String toStatusName;

    /**
     * 备注
     */
    @Length(max = 500, message = "长度需要大于0且小于500")
    private String remark;

    /**
     * 创建人
     */
    @NotBlank
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * 创建时间
     */
    @NotNull
    private java.util.Date createTime;

    @NotNull
    private java.util.Date occurTime;

    /**
     * 客户ID
     */
    @NotNull
    private Integer customerId;

    private Integer projectId;

    public Date getOccurTime() {
        return occurTime;
    }

    public void setOccurTime(Date occurTime) {
        this.occurTime = occurTime;
    }

    private Integer isRepeat;

    //是否参与统计，重复更新同样状态的数据不做统计 ， 1参与统计0不参与统计
    private Integer nonStatistic;

    //记录客户当前置业顾问，不记录的话转移客户后统计数据会有问题
    private Integer customerManagerId;

    //客户当前置业顾问名称
    private String oldValue;
    private String newValue;

    public String getOldValue() {
        return oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public String getNewValue() {
        return newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    //是否有效（0有效1无效）
    private Integer isDelete;

    private String customerManagerName;

    //columns END

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public String getCustomerManagerName() {
        return customerManagerName;
    }

    public void setCustomerManagerName(String customerManagerName) {
        this.customerManagerName = customerManagerName;
    }

    public Integer getCustomerManagerId() {
        return customerManagerId;
    }

    public void setCustomerManagerId(Integer customerManagerId) {
        this.customerManagerId = customerManagerId;
    }

    public Integer getNonStatistic() {
        return nonStatistic;
    }

    public void setNonStatistic(Integer nonStatistic) {
        this.nonStatistic = nonStatistic;
    }

    public Integer getIsRepeat() {
        return isRepeat;
    }

    public void setIsRepeat(Integer isRepeat) {
        this.isRepeat = isRepeat;
    }

    public Integer getProjectId() {
        return projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取变更前状态 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     *
     * @return 变更前状态 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    public Integer getFromStatusId() {
        return this.fromStatusId;
    }

    /**
     * 设置变更前状态 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     *
     * @param fromStatusId 变更前状态 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    public void setFromStatusId(Integer fromStatusId) {
        this.fromStatusId = fromStatusId;
    }

    /**
     * 获取变更后状态 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     *
     * @return 变更后状态 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    public Integer getToStatusId() {
        return this.toStatusId;
    }

    /**
     * 设置变更后状态 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     *
     * @param toStatusId 变更后状态 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    public void setToStatusId(Integer toStatusId) {
        this.toStatusId = toStatusId;
    }

    /**
     * 获取变更前状态名称 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     *
     * @return 变更前状态名称 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    public String getFromStatusName() {
        return this.fromStatusName;
    }

    /**
     * 设置变更前状态名称 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     *
     * @param fromStatusName 变更前状态名称 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    public void setFromStatusName(String fromStatusName) {
        this.fromStatusName = fromStatusName;
    }

    /**
     * 获取变更后状态名称 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     *
     * @return 变更后状态名称 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    public String getToStatusName() {
        return this.toStatusName;
    }

    /**
     * 设置变更后状态名称 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     *
     * @param toStatusName 变更后状态名称 0未约看 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    public void setToStatusName(String toStatusName) {
        this.toStatusName = toStatusName;
    }

    /**
     * 获取备注
     *
     * @return 备注
     */
    public String getRemark() {
        return this.remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取创建人
     *
     * @return 创建人
     */
    public String getCreater() {
        return this.creater;
    }

    /**
     * 设置创建人
     *
     * @param creater 创建人
     */
    public void setCreater(String creater) {
        this.creater = creater;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取客户ID
     *
     * @return 客户ID
     */
    public Integer getCustomerId() {
        return this.customerId;
    }

    /**
     * 设置客户ID
     *
     * @param customerId 客户ID
     */
    public void setCustomerId(Integer customerId) {
        this.customerId = customerId;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("FromStatusId",
                                                                                                      getFromStatusId()).append(
            "ToStatusId", getToStatusId()).append("FromStatusName", getFromStatusName()).append("ToStatusName",
                                                                                                getToStatusName()).append(
            "Remark", getRemark()).append("Creater", getCreater()).append("CreateTime", getCreateTime()).append(
            "CustomerId", getCustomerId()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CustomerStatusLogEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CustomerStatusLogEntity other = (CustomerStatusLogEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

