/**
 * Description: BaseTree数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-08 下午 15:16:07
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-08   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.common.Treeable;
import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * BaseTree数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-08
 * @see
 * @since 1.0
 */
public class BaseTreeEntity extends DomainObject implements Treeable<BaseTreeEntity> {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * name
     */
    @Length(max = 128, message = "长度需要大于0且小于128")
    private String name;

    /**
     * urlPath
     */
    @Length(max = 256, message = "长度需要大于0且小于256")
    private String urlPath;

    /**
     * status
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String status;

    /**
     * parentId
     */

    private Integer parentId;

    /**
     * orderNum
     */

    private Integer orderNum;

    /**
     * fullPath
     */
    @Length(max = 256, message = "长度需要大于0且小于256")
    private String fullPath;

    /**
     * hierarchy
     */

    private Integer hierarchy;

    /**
     * descripition
     */
    @Length(max = 128, message = "长度需要大于0且小于128")
    private String descripition;

    /**
     * createTime
     */

    private java.util.Date createTime;

    /**
     * updateTime
     */

    private java.util.Date updateTime;

    /**
     * creator
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creator;

    /**
     * updater
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String updater;

    /**
     * sourceId
     */
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String sourceId;

    /**
     * sourceType
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String sourceType;

    //columns END
  /*
	public BaseTree(){
	}

	public BaseTree(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 设置name
     * @param name name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取name
     * @return name
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置urlPath
     * @param urlPath urlPath
     */
    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    /**
     * 获取urlPath
     * @return urlPath
     */
    public String getUrlPath() {
        return this.urlPath;
    }

    /**
     * 设置status
     * @param status status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * 获取status
     * @return status
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * 设置parentId
     * @param parentId parentId
     */
    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    /**
     * 获取parentId
     * @return parentId
     */
    public Integer getParentId() {
        return this.parentId;
    }

    /**
     * 设置orderNum
     * @param orderNum orderNum
     */
    public void setOrderNum(Integer orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * 获取orderNum
     * @return orderNum
     */
    public Integer getOrderNum() {
        return this.orderNum;
    }

    /**
     * 设置fullPath
     * @param fullPath fullPath
     */
    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    /**
     * 获取fullPath
     * @return fullPath
     */
    public String getFullPath() {
        return this.fullPath;
    }

    /**
     * 设置hierarchy
     * @param hierarchy hierarchy
     */
    public void setHierarchy(Integer hierarchy) {
        this.hierarchy = hierarchy;
    }

    /**
     * 获取hierarchy
     * @return hierarchy
     */
    public Integer getHierarchy() {
        return this.hierarchy;
    }

    /**
     * 设置descripition
     * @param descripition descripition
     */
    public void setDescripition(String descripition) {
        this.descripition = descripition;
    }

    /**
     * 获取descripition
     * @return descripition
     */
    public String getDescripition() {
        return this.descripition;
    }

    /**
     * 设置createTime
     * @param createTime createTime
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置createTime字符串格式
     * @param createTime createTime
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取createTime
     * @return createTime
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置updateTime
     * @param updateTime updateTime
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 设置updateTime字符串格式
     * @param updateTime updateTime
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取updateTime
     * @return updateTime
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置creator
     * @param creator creator
     */
    public void setCreator(String creator) {
        this.creator = creator;
    }

    /**
     * 获取creator
     * @return creator
     */
    public String getCreator() {
        return this.creator;
    }

    /**
     * 设置updater
     * @param updater updater
     */
    public void setUpdater(String updater) {
        this.updater = updater;
    }

    /**
     * 获取updater
     * @return updater
     */
    public String getUpdater() {
        return this.updater;
    }

    /**
     * 设置sourceId
     * @param sourceId sourceId
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * 获取sourceId
     * @return sourceId
     */
    public String getSourceId() {
        return this.sourceId;
    }

    /**
     * 设置sourceType
     * @param sourceType sourceType
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 获取sourceType
     * @return sourceType
     */
    public String getSourceType() {
        return this.sourceType;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("Name",
                                                                                                      getName()).append(
            "UrlPath", getUrlPath()).append("Status", getStatus()).append("ParentId", getParentId()).append("OrderNum",
                                                                                                            getOrderNum()).append(
            "FullPath", getFullPath()).append("Hierarchy", getHierarchy()).append("Descripition",
                                                                                  getDescripition()).append(
            "CreateTime", getCreateTime()).append("UpdateTime", getUpdateTime()).append("Creator", getCreator()).append(
            "Updater", getUpdater()).append("SourceId", getSourceId()).append("SourceType", getSourceType()).toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof BaseTreeEntity == false)
            return false;
        if (this == obj)
            return true;
        BaseTreeEntity other = (BaseTreeEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

