package com.house365.ws.system;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.house365.beans.system.UserAttributes;

/**
 * TOP请求接口。
 */
public class House365Request implements Serializable {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 随机码
     */
    private String randomNumber;

    /**
     * 加密随机码
     */
    private String encryptRandomNumber;

    /**
     * 加公共参数map
     */
    private Map<String, Object> commonParam;

    /**
     * 加私有的参数map
     */
    private Map<String, Object> paramMap = new HashMap<String, Object>();

    private byte[] encode;

    /**
     * 用户属性
     */
    private UserAttributes userAttributes = null;

    public String getRandomNumber() {
        return randomNumber;
    }

    public void setRandomNumber(String randomNumber) {
        this.randomNumber = randomNumber;
    }

    public String getEncryptRandomNumber() {
        return encryptRandomNumber;
    }

    public void setEncryptRandomNumber(String encryptRandomNumber) {
        this.encryptRandomNumber = encryptRandomNumber;
    }

    public Map<String, Object> getCommonParam() {
        return commonParam;
    }

    public void setCommonParam(Map<String, Object> commonParam) {
        this.commonParam = commonParam;
    }

    public Map<String, Object> getParamMap() {
        return paramMap;
    }

    public void setParamMap(Map<String, Object> paramMap) {
        this.paramMap = paramMap;
    }

    public byte[] getEncode() {
        return encode;
    }

    public void setEncode(byte[] encode) {
        this.encode = encode;
    }

    /**
     * @return the userAttributes
     */
    public UserAttributes getUserAttributes() {
        return userAttributes;
    }

    /**
     * @param userAttributes the userAttributes to set
     */
    public void setUserAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
    }
}
