package com.house365.commons.system;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * 远程IP工具
 *
 * @author chengjianfang
 * @version v1.0.0 2015-03-18
 */
public class RemoteIpUtils {
    /**
     * 获取IP地址
     *
     * @param request HTTP请求
     * @return IP地址
     */
    public static final String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (notRealIp(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
            if (notRealIp(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
                if (notRealIp(ip)) {
                    ip = request.getRemoteAddr();
                }
            }
        }
        return ip;
    }

    /**
     * 是否非真实IP
     *
     * @param ip IP值
     * @return 是否非真实IP<li>true--不是真实IP<li>false--是真实IP
     */
    private static final boolean notRealIp(final String ip) {
        return StringUtils.isEmpty(ip) || StringUtils.equalsIgnoreCase("unknown", ip);
    }
}
