/**
 * Description: ProjectSourceStatistics业务接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-17 下午 14:59:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import java.util.List;

import com.house365.beans.system.QueryParams;
import com.house365.service.system.Interfaces.Service;
import com.house365.beans.entity.ProjectSourceStatisticsEntity;
import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.beans.po.ProjectSrouceRePo;

/**
 * ProjectSourceStatistics业务接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-17
 * @see
 * @since 1.0
 */
public interface IProjectSourceStatisticsService<T extends ProjectSourceStatisticsEntity> extends Service<T> {
    public List<ProjectSrouceRePo> queryByDay(ProjectSrouceParaPo para);

    public List<ProjectSrouceRePo> queryByWeek(ProjectSrouceParaPo para);

    public List<ProjectSrouceRePo> queryByMonth(ProjectSrouceParaPo para);

    List<ProjectSourceStatisticsEntity> statisticCustomer(QueryParams para);

    void updateNames();

    void deleteByDate(String startDateStr);

}
