/**
 * Description: CmDictionary业务接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-08-30 下午 13:46:00
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-08-30   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.entity.DictionaryEntity;
import com.house365.service.system.Interfaces.Service;

import java.util.List;

/**
 * CmDictionary业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-30
 * @see
 * @since 1.0
 */
public interface IDictionaryService<T extends DictionaryEntity> extends Service<T> {

    public T getByKey(String key);

    public T getByKeyAndCity(String key, String city);

    List<DictionaryEntity> getListByKey(String key);

    public void deleteByKey(String key);

}
