/**
 * Description: ProjectSourceStatistics业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-17 下午 14:59:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.ProjectSourceStatisticsEntity;
import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.beans.po.ProjectSrouceRePo;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IProjectSourceStatisticsDao;
import com.house365.ws.service.interfaces.IProjectSourceStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * ProjectSourceStatistics业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-17
 * @see
 * @since 1.0
 */
@Service("projectSourceStatisticsService")
public class ProjectSourceStatisticsServiceImpl<T extends ProjectSourceStatisticsEntity> extends DefaultServiceImpl<T> implements IProjectSourceStatisticsService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IProjectSourceStatisticsDao<T> projectSourceStatisticsDao;

    @Override
    protected Dao<T> getDao() {
        return projectSourceStatisticsDao;
    }

    @Override
    public List<ProjectSrouceRePo> queryByDay(ProjectSrouceParaPo para) {
        return projectSourceStatisticsDao.queryByDay(para);
    }

    @Override
    public List<ProjectSrouceRePo> queryByWeek(ProjectSrouceParaPo para) {
        return projectSourceStatisticsDao.queryByWeek(para);
    }

    @Override
    public List<ProjectSrouceRePo> queryByMonth(ProjectSrouceParaPo para) {
        return projectSourceStatisticsDao.queryByMonth(para);
    }

    @Override
    public List<ProjectSourceStatisticsEntity> statisticCustomer(QueryParams para) {
        return projectSourceStatisticsDao.statisticCustomer(para);
    }

    @Override
    public void updateNames() {
        projectSourceStatisticsDao.updateProjectName();
        projectSourceStatisticsDao.updateSourceName();
        projectSourceStatisticsDao.updateCityName();
    }

    @Override
    public void deleteByDate(String startDateStr) {
        projectSourceStatisticsDao.deleteByDate(startDateStr);
    }
}
