/**
 * Description: HouseInfo业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-18 下午 15:44:53
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.house365.beans.entity.HouseInfoEntity;
import com.house365.beans.entity.MarketBuildingRelEntity;
import com.house365.beans.entity.MarketCustomerEntity;
import com.house365.beans.entity.MarketingActivityEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IHouseInfoDao;
import com.house365.ws.dao.interfaces.IMarketBuildingRelDao;
import com.house365.ws.dao.interfaces.IMarketCustomerDao;
import com.house365.ws.dao.interfaces.IMarketingActivityDao;
import com.house365.ws.service.interfaces.IHouseInfoService;
import com.house365.ws.util.PhpInterfaceUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * HouseInfo业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-18
 * @see
 * @since 1.0
 */
@Service("houseInfoService")
public class HouseInfoServiceImpl<T extends HouseInfoEntity> extends DefaultServiceImpl<T> implements IHouseInfoService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IHouseInfoDao<HouseInfoEntity> houseInfoDao;
    @Autowired
    private IMarketCustomerDao<MarketCustomerEntity> marketCustomerDao;
    @Autowired
    private IMarketingActivityDao marketingActivityDao;
    @Autowired
    private IMarketBuildingRelDao marketBuildingRelDao;

    @Override
    protected Dao<T> getDao() {
        return (Dao<T>) houseInfoDao;
    }

    @Override
    public List<HouseInfoEntity> getHouseInfoListByActiveId(Integer activeId) {
        return houseInfoDao.getHouseInfoListByActiveId(activeId);
    }

    @Override
    public void updateHouseNameByActiveId(Integer activeId, String cityKey) {
        List<MarketCustomerEntity> customerList = marketCustomerDao.getByActiveId(activeId);
        Set<String> houseIdSet = new HashSet<>();

        for (MarketCustomerEntity customer : customerList) {
            String houseId = customer.getSignupHouseId();
            if (!Strings.isNullOrEmpty(houseId)) {
                if (houseId.contains(",")) {
                    for (String id : houseId.split(",")) {
                        houseIdSet.add(id);
                    }
                } else {
                    houseIdSet.add(houseId);
                }
            }
        }

        if (!houseIdSet.isEmpty()) {
            //get all houseinfo from php
            List<HouseInfoEntity> houseLastest = PhpInterfaceUtils.getHouseByIds(Joiner.on(",").join(houseIdSet),
                                                                                 cityKey, 1);
            //update customer's house name and house table
            for (MarketCustomerEntity customer : customerList) {
                String houseId = customer.getSignupHouseId();
                if (!Strings.isNullOrEmpty(houseId) && Strings.isNullOrEmpty(customer.getSignupHouseName())) {
                    List<String> houseName = new ArrayList<>();
                    for (HouseInfoEntity php : houseLastest) {
                        if (("," + houseId + ",").contains("," + php.getHouseId() + ",")) {
                            houseName.add(php.getHouseName());
                        }
                    }
                    customer.setSignupHouseName(Joiner.on(",").join(houseName));
                    marketCustomerDao.update(customer);
                }
            }
        }

        List<MarketBuildingRelEntity> buildIds = marketBuildingRelDao.getByActid(activeId);
        MarketingActivityEntity activityEntity = (MarketingActivityEntity) marketingActivityDao.getById(activeId);
        Set<String> actHouseIdSet = new HashSet<>();
        for (MarketBuildingRelEntity mbr : buildIds) {
            actHouseIdSet.add(String.valueOf(mbr.getBuildingId()));
        }

        if (!actHouseIdSet.isEmpty()) {
            List<HouseInfoEntity> houseLastest = PhpInterfaceUtils.getHouseByIds(Joiner.on(",").join(actHouseIdSet),
                                                                                 cityKey, 1);
            List<String> houseName = new ArrayList<>();
            for (HouseInfoEntity php : houseLastest) {
                houseName.add(php.getHouseName());
            }

            activityEntity.setProjectName(Joiner.on(",").join(houseName));
            marketingActivityDao.update(activityEntity);
        }

    }


}
