/**
 * Description: 客户活动来源业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 08:58:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.CustomerSourceEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICustomerSourceDao;
import com.house365.ws.service.interfaces.ICustomerSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 客户活动来源业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
@Service("customerSourceService")
public class CustomerSourceServiceImpl<T extends CustomerSourceEntity> extends DefaultServiceImpl<T> implements ICustomerSourceService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ICustomerSourceDao<T> customerSourceDao;

    @Override
    protected Dao<T> getDao() {
        return customerSourceDao;
    }

    /**
     * 更新来源信息，增加纪录时根据城市和来源名校验是否存在，不存在则新增，存在则不做操作
     *
     * @param city       城市
     * @param sourceName 活动来源名称
     * @param source     来源 1 CRM 2 系统录入
     */
    @Override
    public Integer updateSource(String city, String sourceName, String source, String creater) {
        QueryParams queryParams = new QueryParams();

        Map<String, Object> queryMap = new HashMap<>(10);
        queryMap.put("EQ_city", city);
        queryMap.put("EQ_sourceName", sourceName);
        queryMap.put("EQ_source", source);
        queryParams.setSearchParams(queryMap);
        Integer sourceId;
        List<CustomerSourceEntity> list = (List<CustomerSourceEntity>) queryAll(queryParams);
        if (list == null || list.isEmpty()) {
            CustomerSourceEntity customerSourceEntity = new CustomerSourceEntity();
            customerSourceEntity.setCreateTime(new Date());
            customerSourceEntity.setCreater(creater);
            customerSourceEntity.setCity(city);
            customerSourceEntity.setSort(0);
            customerSourceEntity.setSource(source);
            customerSourceEntity.setSourceName(sourceName);
            customerSourceEntity.setType(0);

            sourceId = save((T) customerSourceEntity);
        } else {
            sourceId = list.get(0).getId();
        }

        return sourceId;
    }

}
