package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.CustomerEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.service.interfaces.ICustomerService;
import com.house365.ws.system.ReturnAppResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Date: 2016/11/3</p>
 *
 * @author XN
 * @version 1.0
 */
@Service("statisticCustomer")
public class StatisticCustomer implements IStatisticCustomer {
    private static final Logger LOGGER = LoggerFactory.getLogger("sysLog");

    @Autowired
    private ICustomerService<CustomerEntity> customerService;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        Integer day = map.get("day") == null ? 1 : Integer.parseInt(((String[])map.get("day"))[0]);
        LOGGER.info("execute StatisticCustomer : day[{}]", day);
        customerService.statisticByDay(day);
        return ReturnAppResult.APP_SUCCESS.getResultMessage();
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }
}
