package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.BaseAttachment;
import com.house365.beans.entity.UserEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.IAttachmentService;
import com.house365.ws.service.interfaces.ICustomerStatusLogService;
import com.house365.ws.service.interfaces.IUserService;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.Constant;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service("getUserEvaluation")
public class GetUserEvaluationImpl implements IGetUserEvaluation {

    private final Logger LOGGER = LoggerFactory.getLogger(GetUserEvaluationImpl.class);

    @Autowired
    private IUserService<UserEntity> userService;

    @Autowired
    private ICustomerStatusLogService customerStatusLogService;

    @Autowired
    private IAttachmentService attachmentService;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<UserEntity> response = new House365RestResponse<>();
        // 业务校验统一入口
        try {
            checkInterfaceParameter(map, Constant.AccIdParams);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }
        // 业务层统一处理
        try {
            House365RestObject<UserEntity> data = doBusiness(map);
            response.setData(data);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        String result = JSONObject.fromObject(response).toString();
        return result;
    }

    /**
     * 业务层统校验自己所需参数是否存在
     * 所有参数都要存在
     *
     * @author hqc
     */
    protected void checkInterfaceParameter(
            Map<String, Object> map, String[] checkParams
    ) throws IllegalServiceParameterException {
        // 方法所需参数
        for (String str : checkParams) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }
    }

    /**
     * 业务层统逻辑处理
     */
    private House365RestObject<UserEntity> doBusiness(Map<String, Object> map) throws Exception {
        // 返回Json对象
        House365RestObject<UserEntity> restObject = new House365RestObject<>();
        String accId = getMapValueByKey("accId", map, "");
        String city = getMapValueByKey("cityId", map, "");
        UserEntity userentity = userService.getUserEvaluation(accId);
        if (userentity != null) {
            //400电话
            userentity.setHotlinephone("4008908365,," + userentity.getHotlinephone());
            userentity.setPersonHotline(userentity.getHotlinephone());
            //带看次数
            int seeCount = customerStatusLogService.getSeeCount(userentity.getId());
            //初始带看次数
            int defaultVisit = userentity.getDefaultVisit();
            seeCount += defaultVisit;
            userentity.setSeeCount(seeCount);
            //获取头像
            List<BaseAttachment> headImg = attachmentService.queryByResourceIdAndResouceType(
                    String.valueOf(userentity.getId()), "hgs_user_headImg");
            if (headImg != null && headImg.size() != 0) {
                userentity.setHeadImgURL(headImg.get(0).getRemotePath());
            } else {
                userentity.setHeadImgURL("http://img33.house365.com/M00/1B/86/rBEBp1pu2JyAIp4jAAAGEjOUX2M365.jpg");
            }
            //全身像
            List<BaseAttachment> fullImg = attachmentService.queryByResourceIdAndResouceType(
                    String.valueOf(userentity.getId()), "hgs_user_fullImg");
            if (fullImg != null && fullImg.size() != 0) {
                userentity.setFullImgURL(fullImg.get(0).getRemotePath());
            } else {
                userentity.setFullImgURL("http://img31.house365.com/M00/52/5E/rBEBYFpu2HGAb7o1AAAJ0juvDio725.jpg");
            }
            //查询该城市是否展示IM窗口
            UserEntity imentity = userService.getByCity(city);
            if (imentity != null) {
                userentity.setImshow(imentity.getImshow());
            }
        }
        restObject.setEntity(userentity);
        return restObject;
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

}
