package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.UserProjectRecommendEntity;
import com.house365.beans.system.Page;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.web.util.DateTimeUtils;
import com.house365.ws.beans.request.UserProjectRecommendListRequest;
import com.house365.ws.beans.response.UserProjectRecommendListResponse;
import com.house365.ws.interfaces.server.IUserProjectRecommend;
import net.sf.json.JSONObject;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * Description
 *
 * @author Administrator
 * @date 2018/5/15
 */
@Service("getProjectRecommendListImpl")
public class GetProjectRecommendListImpl implements IGetProjectRecommendList {

    private static final Logger LOGGER = LoggerFactory.getLogger(GetProjectRecommendListImpl.class);

    @Autowired
    private IUserProjectRecommend userProjectRecommend;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        //从淘房汇请求参数取出map
        Map<String, Object> map = parameter.getArgs();

        //取出map中的部分数据
        String city = getMapValueByKey("city", map, "");
        String userId = getMapValueByKey("userId", map, "");
        String currentPage = getMapValueByKey("page", map, "1");
        String pageSize = getMapValueByKey("pageSize", map, "10");


        Page page = new Page();
        page.setPageSize(Integer.valueOf(pageSize));
        page.setCurrentPage(Integer.valueOf(currentPage));

        UserProjectRecommendListRequest userProjectRecommendListRequest = new UserProjectRecommendListRequest();
        userProjectRecommendListRequest.setPaging(page);

        Map<String, Object> searchParams = new HashedMap();
        searchParams.put("EQ_userId", userId);
        searchParams.put("EQ_isDeleted", 0);
        searchParams.put("EQ_city", city);

        userProjectRecommendListRequest.setSearchParams(searchParams);
        userProjectRecommendListRequest.setOrderColumn("id");
        userProjectRecommendListRequest.setOrderMode("desc");

        UserProjectRecommendListResponse listResponse = userProjectRecommend.getUserProjectRecommendList(userProjectRecommendListRequest);
        for (UserProjectRecommendEntity entity : listResponse.getObjectList()) {
            if (null != entity.getUpdateTime()) {
                entity.setUpdateTimeDisplay(DateTimeUtils.parseDate(entity.getUpdateTime(), DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_FULL));

            } else {
                entity.setUpdateTimeDisplay("");
            }
            if (null != entity.getCreateTimeDisplay()) {
                entity.setCreateTimeDisplay(DateTimeUtils.parseDate(entity.getCreateTime(), DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_FULL));
            } else {
                entity.setCreateTimeDisplay("");
            }
        }

        House365RestObject<UserProjectRecommendListResponse> restObject = new House365RestObject<>();
        restObject.setEntity(listResponse);
        return JSONObject.fromObject(restObject).toString();
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }
}
