package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.CloudRuleEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.dao.mapper.CloudRuleMapper;
import com.house365.ws.dao.mapper.ProjectMapper;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Created by 365 on 2020/8/13.
 */
@Service("getCloudRule")
public class GetCloudRuleImpl implements IGetCloudRule {

    private Logger logger = LoggerFactory.getLogger(GetCloudRuleImpl.class);

    @Autowired
    private CloudRuleMapper ruleMapper;
    @Autowired
    private ProjectMapper projectMapper;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        House365RestResponse<Map<String, Object>> response = new House365RestResponse<>();
        try {
            Map<String, Object> searchMap = new HashMap<>(10);
            List<CloudRuleEntity> list = ruleMapper.queryByConditions(searchMap);
            if (CollectionUtils.isNotEmpty(list)) {
                List<Map<String, Object>> resultList = new ArrayList<>();
                House365RestObject<Map<String, Object>> restObject = new House365RestObject<>();
                for (CloudRuleEntity c : list) {
                    Map<String, Object> map = new HashMap<>(10);
                    map.put("city", c.getCityCode());
                    map.put("buildingId", c.getProjectId());
                    map.put("buildingName", c.getProjectName());
                    resultList.add(map);
                }
                restObject.setTotal(String.valueOf(list.size()));
                restObject.setList(resultList);
                response.setData(restObject);
                response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            }
        } catch (Exception e) {
            logger.error("获取定制项目列表信息失败", e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        return JSONObject.fromObject(response).toString();
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
