/**
 * Description: 统计信息WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-27 下午 15:54:06
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-27   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.alibaba.dubbo.common.json.JSONArray;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.house365.beans.entity.StatisticEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.beans.request.StatisticListRequest;
import com.house365.ws.beans.request.StatisticRequest;
import com.house365.ws.beans.response.StatisticListResponse;
import com.house365.ws.beans.response.StatisticResponse;
import com.house365.ws.interfaces.server.IStatistic;
import com.house365.ws.service.interfaces.IStatisticService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

//import org.house365.core.support.QueryParams;

/**
 * 统计信息WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-27
 * @see
 * @since 1.0
 */
@Service("statistic")
public class StatisticImpl implements IStatistic {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticImpl.class);

    /**
     * 统计信息服务对象
     */
    @Autowired
    IStatisticService<StatisticEntity> statisticService;

    /**
     * 统计信息列表查询
     *
     * @param request 统计信息列表查询请求
     * @return 统计信息列表查询响应
     */
    @Override
    public StatisticListResponse getStatisticList(StatisticListRequest request) {
        StatisticListResponse response = new StatisticListResponse();
        try {
            QueryParams<StatisticEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<StatisticEntity> statistics = statisticService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(statistics);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存统计信息
     *
     * @param request 统计信息请求
     * @return 保存统计信息响应
     */
    @Override
    public StatisticResponse addStatistic(StatisticRequest request) {
        StatisticResponse response = new StatisticResponse();
        try {
            StatisticEntity entity = request.getEntity();
            statisticService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除统计信息通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除统计信息响应
     */
    @Override
    public StatisticResponse deleteStatisticById(Integer id) {
        StatisticResponse response = new StatisticResponse();
        try {
            statisticService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改统计信息
     *
     * @param request 修改统计信息请求
     * @return 修改统计信息响应
     */
    @Override
    public StatisticResponse updateStatistic(StatisticRequest request) {
        StatisticResponse response = new StatisticResponse();
        try {
            statisticService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取统计信息
     *
     * @param id 唯一标识
     * @return 通过ID获取统计信息响应
     */
    @Override
    public StatisticResponse getStatisticById(Integer id) {
        StatisticResponse response = new StatisticResponse();
        try {
            StatisticEntity entity = statisticService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public House365RestResponse getDistinctReportName(String city) {
        House365RestResponse response = new House365RestResponse();
        House365RestObject object = new House365RestObject();
        try {
            List<HashMap<String, String>> statistics = statisticService.getDistinctReportName(city);
            object.setList(statistics);
            response.setData(object);
            response.setResult(ReturnResult.SUCCESS.getResultCode());
            response.setMsg(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResult(ReturnResult.FAIL.getResultCode());
            response.setMsg(ex.getMessage());
        }
        return response;
    }

    @Override
    public HashMap<String, HashMap<String, List<String>>> getIndexReport(String city) {
        HashMap<String, HashMap<String, List<String>>> map = new HashMap<>();

        QueryParams queryParams = new QueryParams();
        Map<String, Object> searchMap = new HashMap<>();
        searchMap.put("EQ_deptCityId", city);
        queryParams.setSearchParams(searchMap);
        queryParams.setOrderColumn("buy_num asc");
        queryParams.setOrderMode(" ,sort asc");
        List<StatisticEntity> statisticEntities = statisticService.queryAll(queryParams);
        JSONArray data = new JSONArray();
        data.add(Lists.newArrayList("认购宗数", "认购业绩"));

        HashMap<String, List<String>> report1 = new HashMap<>();
        HashMap<String, List<String>> report2 = new HashMap<>();
        HashMap<String, List<String>> report3 = new HashMap<>();
        HashMap<String, List<String>> report4 = new HashMap<>();

        //认购宗数
        List<String> reportData1 = new ArrayList<>();
        List<String> reportData2 = new ArrayList<>();
        List<String> reportData3 = new ArrayList<>();
        List<String> reportData4 = new ArrayList<>();
        //认购业绩
        List<String> reportData11 = new ArrayList<>();
        List<String> reportData12 = new ArrayList<>();
        List<String> reportData13 = new ArrayList<>();
        List<String> reportData14 = new ArrayList<>();
        //业务员姓名
        List<String> reportName1 = new ArrayList<>();
        List<String> reportName2 = new ArrayList<>();
        List<String> reportName3 = new ArrayList<>();
        List<String> reportName4 = new ArrayList<>();

        for (StatisticEntity statisticEntity : statisticEntities) {
            if (statisticEntity.getSort() == 1) {
                report1.put("title", Lists.newArrayList(
                        Strings.isNullOrEmpty(statisticEntity.getReportName()) ? "" : statisticEntity.getReportName()));
                reportName1.add(statisticEntity.getName());
                reportData11.add(String.valueOf(statisticEntity.getPerformance()));
                reportData1.add(String.valueOf(statisticEntity.getBuyNum()));
            } else if (statisticEntity.getSort() == 2) {
                report2.put("title", Lists.newArrayList(
                        Strings.isNullOrEmpty(statisticEntity.getReportName()) ? "" : statisticEntity.getReportName()));
                reportName2.add(statisticEntity.getName());
                reportData12.add(String.valueOf(statisticEntity.getPerformance()));
                reportData2.add(String.valueOf(statisticEntity.getBuyNum()));
            } else if (statisticEntity.getSort() == 3) {
                report3.put("title", Lists.newArrayList(
                        Strings.isNullOrEmpty(statisticEntity.getReportName()) ? "" : statisticEntity.getReportName()));
                reportName3.add(statisticEntity.getName());
                reportData13.add(String.valueOf(statisticEntity.getPerformance()));
                reportData3.add(String.valueOf(statisticEntity.getBuyNum()));
            } else if (statisticEntity.getSort() == 4) {
                report4.put("title", Lists.newArrayList(
                        Strings.isNullOrEmpty(statisticEntity.getReportName()) ? "" : statisticEntity.getReportName()));
                reportName4.add(statisticEntity.getName());
                reportData14.add(String.valueOf(statisticEntity.getPerformance()));
                reportData4.add(String.valueOf(statisticEntity.getBuyNum()));
            }
        }

        report1.put("names", reportName1);
        report1.put("performance", reportData11);
        report1.put("buyNum", reportData1);

        report2.put("names", reportName2);
        report2.put("performance", reportData12);
        report2.put("buyNum", reportData2);

        report3.put("names", reportName3);
        report3.put("performance", reportData13);
        report3.put("buyNum", reportData3);

        report4.put("names", reportName4);
        report4.put("performance", reportData14);
        report4.put("buyNum", reportData4);

        map.put("report1", report1);
        map.put("report2", report2);
        map.put("report3", report3);
        map.put("report4", report4);

        return map;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
