/**
 * Description: 权限WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.PermissionEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.PermissionListRequest;
import com.house365.ws.beans.request.PermissionRequest;
import com.house365.ws.beans.response.PermissionListResponse;
import com.house365.ws.beans.response.PermissionResponse;
import com.house365.ws.interfaces.server.IPermission;
import com.house365.ws.service.interfaces.IPermissionService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

//import org.house365.core.support.QueryParams;

/**
 * 权限WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Service("permission")
public class PermissionImpl implements IPermission {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionImpl.class);

    /**
     * 权限服务对象
     */
    @Autowired
    IPermissionService<PermissionEntity> permissionService;

    /**
     * 权限列表查询
     *
     * @param request
     *            权限列表查询请求
     * @return 权限列表查询响应
     */
    @Override
    public PermissionListResponse getPermissionList(PermissionListRequest request) {
        PermissionListResponse response = new PermissionListResponse();
        try {
            QueryParams<PermissionEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<PermissionEntity> permissions = permissionService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(permissions);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存权限
     *
     * @param request
     *            权限请求
     * @return 保存权限响应
     */
    @Override
    public PermissionResponse addPermission(PermissionRequest request) {
        PermissionResponse response = new PermissionResponse();
        try {
            PermissionEntity entity = request.getEntity();
            permissionService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除权限通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除权限响应
     */
    @Override
    public PermissionResponse deletePermissionById(Integer id) {
        PermissionResponse response = new PermissionResponse();
        try {
            permissionService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改权限
     *
     * @param request
     *            修改权限请求
     * @return 修改权限响应
     */
    @Override
    public PermissionResponse updatePermission(PermissionRequest request) {
        PermissionResponse response = new PermissionResponse();
        try {
            permissionService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取权限
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取权限响应
     */
    @Override
    public PermissionResponse getPermissionById(Integer id) {
        PermissionResponse response = new PermissionResponse();
        try {
            PermissionEntity entity = permissionService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
