/**
 * Description: MarketBuildingRelWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:20:56
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.MarketBuildingRelEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.MarketBuildingRelListRequest;
import com.house365.ws.beans.request.MarketBuildingRelRequest;
import com.house365.ws.beans.response.MarketBuildingRelListResponse;
import com.house365.ws.beans.response.MarketBuildingRelResponse;
import com.house365.ws.interfaces.server.IMarketBuildingRel;
import com.house365.ws.service.interfaces.IMarketBuildingRelService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * MarketBuildingRelWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
@Service("marketBuildingRel")
public class MarketBuildingRelImpl implements IMarketBuildingRel {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(MarketBuildingRelImpl.class);

    /**
     * MarketBuildingRel服务对象
     */
    @Autowired
    IMarketBuildingRelService<MarketBuildingRelEntity> marketBuildingRelService;

    /**
     * MarketBuildingRel列表查询
     *
     * @param request MarketBuildingRel列表查询请求
     * @return MarketBuildingRel列表查询响应
     */
    @Override
    public MarketBuildingRelListResponse getMarketBuildingRelList(MarketBuildingRelListRequest request) {
        MarketBuildingRelListResponse response = new MarketBuildingRelListResponse();
        try {
            QueryParams<MarketBuildingRelEntity> queryParams = new QueryParams<>(
                    request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<MarketBuildingRelEntity> marketBuildingRels = marketBuildingRelService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(marketBuildingRels);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存MarketBuildingRel
     *
     * @param request MarketBuildingRel请求
     * @return 保存MarketBuildingRel响应
     */
    @Override
    public MarketBuildingRelResponse addMarketBuildingRel(MarketBuildingRelRequest request) {
        MarketBuildingRelResponse response = new MarketBuildingRelResponse();
        try {
            MarketBuildingRelEntity entity = request.getEntity();
            marketBuildingRelService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除MarketBuildingRel通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除MarketBuildingRel响应
     */
    @Override
    public MarketBuildingRelResponse deleteMarketBuildingRelById(Integer id) {
        MarketBuildingRelResponse response = new MarketBuildingRelResponse();
        try {
            marketBuildingRelService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改MarketBuildingRel
     *
     * @param request 修改MarketBuildingRel请求
     * @return 修改MarketBuildingRel响应
     */
    @Override
    public MarketBuildingRelResponse updateMarketBuildingRel(MarketBuildingRelRequest request) {
        MarketBuildingRelResponse response = new MarketBuildingRelResponse();
        try {
            marketBuildingRelService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取MarketBuildingRel
     *
     * @param id 唯一标识
     * @return 通过ID获取MarketBuildingRel响应
     */
    @Override
    public MarketBuildingRelResponse getMarketBuildingRelById(Integer id) {
        MarketBuildingRelResponse response = new MarketBuildingRelResponse();
        try {
            MarketBuildingRelEntity entity = marketBuildingRelService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public void deleteByActiveId(Integer id) {
        marketBuildingRelService.deleteByActiveId(id);
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
