/**
 * Description: 客户-置业顾问关联WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-03-14 下午 13:43:59
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-03-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CustomerUserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CustomerUserListRequest;
import com.house365.ws.beans.request.CustomerUserRequest;
import com.house365.ws.beans.response.CustomerUserListResponse;
import com.house365.ws.beans.response.CustomerUserResponse;
import com.house365.ws.interfaces.server.ICustomerUser;
import com.house365.ws.service.interfaces.ICustomerUserService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * 客户-置业顾问关联WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-03-14
 * @see
 * @since 1.0
 */
@Service("customerUser")
public class CustomerUserImpl implements ICustomerUser {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerUserImpl.class);

    /**
     * 客户-置业顾问关联服务对象
     */
    @Autowired
    private ICustomerUserService<CustomerUserEntity> customerUserService;

    /**
     * 客户-置业顾问关联列表查询
     *
     * @param request 客户-置业顾问关联列表查询请求
     * @return 客户-置业顾问关联列表查询响应
     */
    @Override
    public CustomerUserListResponse getCustomerUserList(CustomerUserListRequest request) {
        CustomerUserListResponse response = new CustomerUserListResponse();
        try {
            QueryParams<CustomerUserEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CustomerUserEntity> customerUsers = customerUserService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(customerUsers);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存客户-置业顾问关联
     *
     * @param request 客户-置业顾问关联请求
     * @return 保存客户-置业顾问关联响应
     */
    @Override
    public CustomerUserResponse addCustomerUser(CustomerUserRequest request) {
        CustomerUserResponse response = new CustomerUserResponse();
        try {
            CustomerUserEntity entity = request.getEntity();
            customerUserService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除客户-置业顾问关联通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除客户-置业顾问关联响应
     */
    @Override
    public CustomerUserResponse deleteCustomerUserById(Integer id) {
        CustomerUserResponse response = new CustomerUserResponse();
        try {
            customerUserService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改客户-置业顾问关联
     *
     * @param request 修改客户-置业顾问关联请求
     * @return 修改客户-置业顾问关联响应
     */
    @Override
    public CustomerUserResponse updateCustomerUser(CustomerUserRequest request) {
        CustomerUserResponse response = new CustomerUserResponse();
        try {
            customerUserService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取客户-置业顾问关联
     *
     * @param id 唯一标识
     * @return 通过ID获取客户-置业顾问关联响应
     */
    @Override
    public CustomerUserResponse getCustomerUserById(Integer id) {
        CustomerUserResponse response = new CustomerUserResponse();
        try {
            CustomerUserEntity entity = customerUserService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
