package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CloudCustomerEntity;
import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.ws.beans.request.MapListRequest;
import com.house365.ws.beans.response.MapListResponse;
import com.house365.ws.beans.util.HResult;
import com.house365.ws.cached.RedisUtilsInterface;
import com.house365.ws.dao.mapper.CloudCustomerMapper;
import com.house365.ws.dao.mapper.CustomerMapper;
import com.house365.ws.interfaces.server.ICloudCustomerInterface;
import com.house365.ws.system.ReturnResult;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author Created by Administrator on 2020/3/26.
 */
@Service("cloudCustomer")
public class CloudCustomerImpl implements ICloudCustomerInterface {

    private static final Logger logger = LoggerFactory.getLogger(CloudCustomerImpl.class);

    @Autowired
    private CloudCustomerMapper mapper;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private RedisUtilsInterface redisUtil;

    @Override
    public MapListResponse list(MapListRequest request, int activeId) {
        MapListResponse response = new MapListResponse();
        try {
            Map<String, Object> map = new HashMap<>(10);
            Map<String, Object> searchParams = request.getSearchParams();
            map.put("city", searchParams.get("city"));
            map.put("phone", searchParams.get("phone"));

            map.put("latestSource", searchParams.get("latestSource"));
            map.put("actSource", searchParams.get("actSource"));
            map.put("managerName", searchParams.get("managerName"));
            map.put("signupHouseName", searchParams.get("signupHouseName"));
            map.put("activeId", activeId);
            if (StringUtils.isNotBlank(searchParams.get("type").toString())) {
                map.put("type", 2);
            } else {
                map.put("type", 1);
            }
            List<Map<String, Object>> list;
            int count = 0;

            //todo 添加状态查询
            if (null != searchParams.get("status")) {
                int status = Integer.parseInt(searchParams.get("status").toString());
                String seeIdKey = "cloud_see_Id" + activeId;
                String daoIdKey = "cloud_dao_Id" + activeId;
                String buyIdKey = "cloud_buy_Id" + activeId;
                String signIdKey = "cloud_sign_Id" + activeId;
                String cancelIdKey = "cloud_cancel_Id" + activeId;
                String renIdKey = "cloud_ren_Id" + activeId;
                list = mapper.queryList(map);
                if (status == 1) {
                    String value = redisUtil.getValByKey(seeIdKey);
                    dealList(list, value);
                } else if (status == 2) {
                    String value = redisUtil.getValByKey(daoIdKey);
                    dealList(list, value);
                } else if (status == 3) {
                    String value = redisUtil.getValByKey(renIdKey);
                    dealList(list, value);
                } else if (status == 4) {
                    String value = redisUtil.getValByKey(buyIdKey);
                    dealList(list, value);
                } else if (status == 5) {
                    String value = redisUtil.getValByKey(signIdKey);
                    dealList(list, value);
                } else if (status == 6) {
                    String value = redisUtil.getValByKey(cancelIdKey);
                    dealList(list, value);
                }
                int total = list.size();
                List<Map<String, Object>> subList = new ArrayList<>();
                //手动分页，需要先查出全部然后筛选重新分页
                for (int i = 0; i <= total; i++) {
                    // 开始索引
                    int currentPage = request.getPaging().getCurrentPage();
                    int fromIndex = (currentPage - 1) * request.getPaging().getPageSize();
                    // 结束索引
                    int toIndex = fromIndex + request.getPaging().getPageSize();
                    // 如果结束索引大于集合的最大索引，那么规定结束索引=集合大小
                    if (toIndex > total) {
                        toIndex = total;
                    }
                    if (fromIndex <= total) {
                        subList = list.subList(fromIndex, toIndex);
                        if (toIndex >= fromIndex) {
                            break;
                        }
                    }
                }
                count = subList.size();
                response.setObjectList(subList);
            } else {
                int start = 50 * (request.getPaging().getCurrentPage() - 1);
                map.put("start", start);
                map.put("limit", 50);
                list = mapper.queryList(map);
                count = mapper.queryCount(map);
                response.setObjectList(list);
            }

            map.put("type", 1);
            List<CloudCustomerEntity> waitCountList = mapper.queryByConditions(map);
            response.setWaitCount(waitCountList.size());
            map.put("type", 2);
            List<CloudCustomerEntity> sentCountList = mapper.queryByConditions(map);
            response.setSentCount(sentCountList.size());
            map.put("type", 0);
            List<CloudCustomerEntity> customerCountList = mapper.queryByConditions(map);
            response.setCustomerCount(customerCountList.size());
            request.getPaging().setRecords(count);
            response.setPaging(request.getPaging());
            response.setObjectList(list);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(e.getMessage());
        }
        return response;
    }

    private void dealList(List<Map<String, Object>> list, String value) {
        Iterator<Map<String, Object>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> listMap = iterator.next();
            String phone = listMap.get("phone").toString();
            if (!value.contains(phone)) {
                iterator.remove();
            }
        }
    }

    @Override
    public List<CloudCustomerEntity> queryByConditions(Map<String, Object> map) {
        List<CloudCustomerEntity> list = mapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public CloudCustomerEntity getById(int id) {
        return mapper.getById(id);
    }

    @Override
    public HResult judgeCustomer(int id) {
        HResult result = new HResult();
        try {
            CloudCustomerEntity entity = mapper.getById(id);
            if (entity != null) {
                int customerId = entity.getCustomerId();
                CustomerEntity customerEntity = customerMapper.queryById(customerId);
                if (customerEntity != null) {
                    if (customerEntity.getManagerId() != null) {
                        if (customerEntity.getIsWaitCall() != null && customerEntity.getIsWaitCall() == 1) {
                            result.setErrorMessage("该客户尚未回访");
                            result.setStatus(-1);
                            return result;
                        } else {
                            result.setData(entity);
                        }
                    } else {
                        result.setData(entity);
                        result.setErrorMessage("该客户已回公海");
                        result.setStatus(101);
                        return result;
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            result.setErrorMessage("查看云迹活动客户是否是私客失败");
            result.setStatus(500);
        }
        return result;
    }

    @Override
    public void updateById(int customerId, UserEntity user) {
        Map<String, Object> map = new HashMap<>(10);
        map.put("customerId", customerId);
        List<CloudCustomerEntity> list = mapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            CloudCustomerEntity c = list.get(0);
            c.setManagerId(user.getId());
            c.setManagerName(user.getRealName());
            c.setBindTime(new Date());
            mapper.update(c);
        }
    }

}
