/**
 * Description: 营销日报数据访问接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 下午 13:27:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.ReportMarketingEntity;
import com.house365.beans.po.ReportDailyPo;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.ReportMarketingFormVo;
import com.house365.dao.system.interfaces.Dao;

import java.util.List;
import java.util.Map;

/**
 * 营销日报数据访问接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public interface IReportMarketingDao<T extends ReportMarketingEntity> extends Dao<T> {
    List<ReportDailyPo> getDailies(Map<String, Object> param);

    List<ReportMarketingFormVo> statistic(QueryParams<?> queryParams);

    List<ReportMarketingEntity> getByUserId(Map<String, Object> param);

    void updateByUserId(ReportMarketingEntity reportmarketingentity);

    int countStatistic(QueryParams<?> params);
}
