/**
 * Description: 营销活动数据访问实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:20:59
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.MarketingActivityEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IMarketingActivityDao;
import org.springframework.stereotype.Repository;

/**
 * 营销活动数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
@Repository("marketingActivityDao")
public class MarketingActivityDaoImpl extends DefaultDaoImpl<MarketingActivityEntity> implements IMarketingActivityDao<MarketingActivityEntity> {

    @Override
    public Integer queryProtectCount(String phone) {
        return (Integer) getWriteTemplate().queryForObject(getStatement(), phone);
    }

    @Override
    public Integer queryCustomerCountByActive(Integer activeId) {
        return (Integer) getWriteTemplate().queryForObject(getStatement(), activeId);
    }

    @Override
    public Integer queryAllPullCount(QueryParams<?> queryParams) {
        return (Integer) getWriteTemplate().queryForObject(getStatement(), queryParams);
    }

    @Override
    public void setDisable(Integer id) {
        getWriteTemplate().update(getStatement(), id);
    }

    @Override
    public void addCallBackCount(Integer id) {
        getWriteTemplate().update(getStatement(), id);
    }

    @Override
    public void addWaitVisitCount(Integer id) {
        getWriteTemplate().update(getStatement(), id);
    }

    @Override
    public void addBughtCount(Integer id) {
        getWriteTemplate().update(getStatement(), id);
    }

    @Override
    public void addOverTimeCount(Integer id) {
        getWriteTemplate().update(getStatement(), id);
    }


}
